% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse.svd.R
\name{sparse.svd}
\alias{sparse.svd}
\title{Computing the sparse leading left singular vector of a matrix}
\usage{
sparse.svd(Z, lambda, schatten = c(1, 2), tolerance = 1e-05,
  max.iter = 10000)
}
\arguments{
\item{Z}{Input matrix whose left leading singular vector is to be estimated.}

\item{lambda}{Regularisation parameter}

\item{schatten}{Schatten norm constraint to be used. Default uses Schatten-2-norm, i.e. the Frobenius norm. Also possible to use Schatten-1-norm, the nuclear norm.}

\item{tolerance}{Tolerance criterion for convergence of the ADMM algorithm. Not used when shatten=2.}

\item{max.iter}{Maximum number of iteration in the ADMM algorithm. Not used when shatten=2.}
}
\value{
A vector that has the same length as nrow(Z) is returned.
}
\description{
Estimating the sparse left leading singular vector by first computing a maximiser Mhat of the convex problem
\deqn{<Z, M> - \lambda |M|_1}
subject to the Schatten norm constraint |M|_schatten <= 1 using alternating direction method of multipliers (ADMM). Then the leading left singular vector of Mhat is returned.
}
\details{
In case of schatten = 2, a closed-form solution for Mhat using matrix soft thresholding is possible. We use the closed-form solution instead of the ADMM algorithm to speed up the computation.
}
\examples{
Z <- matrix(rnorm(20),4,5)
lambda <- 0.5
sparse.svd(Z, lambda)
}
