% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateBulk.R
\name{generateBulk}
\alias{generateBulk}
\title{Pseudo bulk data generation function}
\usage{
generateBulk(eset,ct.varname,sample,disease = NULL,ct.sub,prop_mat = NULL,
nbulk = 50,samplewithRep = FALSE,low_s = 0.3,upp_s = 0.7)
}
\arguments{
\item{eset}{The `ExpressionSet` object for single cells.}

\item{ct.varname}{Variable name for 'cell types'.}

\item{sample}{Variable name for subject/samples.}

\item{disease}{Indicate the health condition of subjects.}

\item{ct.sub}{A subset of cell types that are selected to construct pseudo bulk samples. If NULL, then all cell types are used.}

\item{prop_mat}{Manually input the cell-type proportion for pseudo bulk samples.}

\item{nbulk}{The number of pseudo bulk samples to be constructed.}

\item{samplewithRep}{Logical, randomly sample single cells with replacement. Default is F.}

\item{low_s}{Lower support a for uniform distribution U[a,b].}

\item{upp_s}{Upper support b for uniform distribution U[a,b].}
}
\value{
Pseudo bulk samples in the format of `ExpressionSet`,
and the true cell-type proportions.
}
\description{
This function generates a pseudo bulk samples by random sampled number of cells per subject.
}
\examples{
##read data
library(InteRD)
readRDSFromWeb<-function(ref) {readRDS(gzcon(url(ref)))}
urlremote<-"https://github.com/chencxxy28/Data/raw/main/data_InteRD/"
seger<-readRDSFromWeb(paste0(urlremote,"segerstolpe.rds"))

##generate a pseudo bulk data with two samples
set.seed(1234567)
pseudo.seger<-generateBulk(seger[["sc.eset.qc"]], ct.varname = "cluster",
sample = "sample", ct.sub = c("alpha","beta","delta","gamma"),
nbulk = 2, low_s = 0.3, upp_s = 0.7)

}
