% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/InterVA.summary.r
\name{summary.interVA}
\alias{summary.interVA}
\title{Summary of the results obtained from InterVA4 algorithm}
\usage{
\method{summary}{interVA}(object, top = 5, id = NULL, InterVA.rule = TRUE,
  ...)
}
\arguments{
\item{object}{fitted object from \code{InterVA()}}

\item{top}{number of top CSMF to show}

\item{id}{the ID of a specific death to show}

\item{InterVA.rule}{If it is set to "TRUE", only the top 3 causes reported by
InterVA4 is calculated into CSMF as in InterVA4. The rest of probabilities
goes into an extra category "Undetermined". Default set to "TRUE".}

\item{...}{not used}
}
\description{
This function prints the summary message of the fitted results.
}
\examples{
data(SampleInput)
## to get easy-to-read version of causes of death make sure the column
## orders match interVA4 standard input this can be monitored by checking
## the warnings of column names

sample.output1 <- InterVA(SampleInput, HIV = "h", Malaria = "l", directory = "VA test",
    filename = "VA_result", output = "extended", append = FALSE, replicate = FALSE)

summary(sample.output1)
summary(sample.output1, top = 10)
summary(sample.output1, id = "100532")
}
\references{
http://www.interva.net/
}
\keyword{InterVA}

