% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isochron.R
\name{isochron}
\alias{isochron}
\alias{isochron.ArAr}
\alias{isochron.ReOs}
\alias{isochron.default}
\title{Calculate and plot isochrons}
\usage{
isochron(x, ...)

\method{isochron}{default}(x, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, ellipse.col = rgb(0, 1, 0, 0.5),
  line.col = "red", lwd = 2, title = TRUE, ...)

\method{isochron}{ArAr}(x, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, ellipse.col = rgb(0, 1, 0, 0.5),
  inverse = TRUE, line.col = "red", lwd = 2, plot = TRUE,
  exterr = TRUE, ...)

\method{isochron}{ReOs}(x, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, ellipse.col = rgb(0, 1, 0, 0.5),
  line.col = "red", lwd = 2, plot = TRUE, exterr = TRUE, ...)
}
\arguments{
\item{x}{EITHER a list or a matrix with the following vectors or
    columns:
\describe{
\item{X}{the x-variable}
\item{sX}{the standard error of \code{X}}
\item{Y}{the y-variable}
\item{sY}{the standard error of \code{Y}}
\item{rXY}{the correlation coefficient of \code{X} and \code{Y}}
}
OR

an object of class \code{ArAr} or \code{ReOs}}

\item{...}{optional arguments}

\item{xlim}{2-element vector with the plot limits of the x-axis}

\item{ylim}{2-element vector with the plot limits of the y-axis}

\item{alpha}{confidence cutoff for the error ellipses}

\item{sigdig}{the number of significant digits of the numerical
values reported in the title of the graphical output}

\item{show.numbers}{logical flag (\code{TRUE} to show grain numbers)}

\item{ellipse.col}{background colour of the error ellipses}

\item{line.col}{colour of the isochron line}

\item{lwd}{line width}

\item{title}{add a title to the plot?}

\item{inverse}{if \code{TRUE}, plots \eqn{^{36}}Ar/\eqn{^{40}}Ar
vs. \eqn{^{39}}Ar/\eqn{^{40}}Ar. If \code{FALSE}, plots
\eqn{^{40}}Ar/\eqn{^{36}}Ar vs. \eqn{^{39}}Ar/\eqn{^{36}}Ar.}

\item{plot}{if \code{FALSE}, suppresses the graphical output}

\item{exterr}{propagate external sources of uncertainty (J, decay constant)?}
}
\value{
if \code{plot=FALSE}, returns a list with the following items:
\describe{
\item{a}{the intercept of the straight line fit and its standard error} 
\item{b}{the slope of the fit and its standard error}
\item{y0}{the atmospheric \eqn{^{40}}Ar/\eqn{^{36}}Ar ratio and its standard error}
\item{age}{the \eqn{^{40}}Ar/\eqn{^{39}}Ar age and its standard error}
}
}
\description{
Plots cogenetic \eqn{^{40}}Ar/\eqn{^{39}}Ar data as X-Y
scatterplots, fits an isochron curve through them using the
\code{yorkfit} function, and computes the corresponding isochron
age, including decay constant uncertainties.
}
\examples{
data(examples)
isochron(examples$ArAr)
}

