% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{yorkfit}
\alias{yorkfit}
\title{Linear regression of X,Y-variables with correlated errors}
\usage{
yorkfit(X, sX = NULL, Y = NULL, sY = NULL, rXY = NULL)
}
\arguments{
\item{X}{EITHER a vector with the X-values OR a 5-column matrix
with the X-values, the analytical uncertainties of the
X-values, the Y-values, the analytical uncertainties of the
Y-values, and the correlation coefficients of the X- and
Y-values.}

\item{sX}{standard errors of \code{X} OR \code{NULL} if X is a
matrix or data frame}

\item{Y}{vector of measurements with the same length as X OR
\code{NULL} if X is a matrix or data frame}

\item{sY}{standard errors of \code{Y} OR \code{NULL} if X is a
matrix or data frame}

\item{rXY}{correlation coefficients between X and Y OR \code{NULL}
if X is a matrix or data frame}
}
\value{
a two-element list of vectors containing: \describe{
    \item{a}{the intercept of the straight line fit and its
    standard error} \item{b}{the slope of the fit and its standard
    error} }
}
\description{
Implements the unified regression algorithm of York et al. (2004)
which, although based on least squares, yields results that are
consistent with maximum likelihood estimates of Ludwig and
Titterington (1994)
}
\examples{
   X <- c(1.550,12.395,20.445,20.435,20.610,24.900,
          28.530,50.540,51.595,86.51,106.40,157.35)
   Y <- c(.7268,.7849,.8200,.8156,.8160,.8322,
          .8642,.9584,.9617,1.135,1.230,1.490)
   n <- length(X)
   sX <- X*0.01
   sY <- Y*0.005
   rXY <- rep(0.8,n)
   fit <- yorkfit(X,sX,Y,sY,rXY)
   covmat <- matrix(0,2,2)
   plot(range(X),fit$a[1]+fit$b[1]*range(X),type='l',ylim=range(Y))
   for (i in 1:n){
       covmat[1,1] <- sX[i]^2
       covmat[2,2] <- sY[i]^2
       covmat[1,2] <- rXY[i]*sX[i]*sY[i]
       covmat[2,1] <- covmat[1,2]
       ell <- ellipse(X[i],Y[i],covmat,alpha=0.05)
       polygon(ell)
   }
}
\references{
Ludwig, K. R., and D. M. Titterington. "Calculation of \eqn{^{230}}Th/U
isochrons, ages, and errors." Geochimica et Cosmochimica Acta
58.22 (1994): 5031-5042.

York, Derek, et al. "Unified equations for the slope,
intercept, and standard errors of the best straight line."
American Journal of Physics 72.3 (2004): 367-375.
}

