% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agespectrum.R
\name{agespectrum}
\alias{agespectrum}
\alias{agespectrum.default}
\alias{agespectrum.ArAr}
\title{Plot a (40Ar/39Ar) release spectrum}
\usage{
agespectrum(x, ...)

\method{agespectrum}{default}(x, alpha = 0.05, plateau = TRUE,
  random.effects = TRUE, levels = NA, clabel = "",
  plateau.col = c("#00FF0080", "#FF000080"),
  non.plateau.col = "#00FFFF80", sigdig = 2, line.col = "red",
  lwd = 2, title = TRUE, show.ci = TRUE,
  xlab = "cumulative fraction", ylab = "age [Ma]", hide = NULL, ...)

\method{agespectrum}{ArAr}(x, alpha = 0.05, plateau = TRUE,
  random.effects = TRUE, levels = NA, clabel = "",
  plateau.col = c("#00FF0080", "#FF000080"),
  non.plateau.col = "#00FFFF80", sigdig = 2, exterr = TRUE,
  line.col = "red", lwd = 2, i2i = FALSE, hide = NULL, ...)
}
\arguments{
\item{x}{a three-column matrix whose first column gives the amount
    of \eqn{^{39}}Ar in each aliquot, and whose second and third
    columns give the age and its uncertainty.

OR

an object of class \code{ArAr}}

\item{...}{optional parameters to the generic \code{plot} function}

\item{alpha}{the confidence level of the error bars/boxes and
confidence intervals.}

\item{plateau}{logical flag indicating whether a plateau age should
be calculated. If \code{plateau=TRUE}, the function will
compute the weighted mean of the largest succession of steps
that pass the Chi-square test for age homogeneity.  If
\code{TRUE}, returns a list with plateau parameters.}

\item{random.effects}{if \code{TRUE}, computes the weighted mean
    using a random effects model with two parameters: the mean and
    the dispersion. This is akin to a `model-3' isochron
    regression.

    if \code{FALSE}, attributes any excess dispersion to an
    underestimation of the analytical uncertainties. This akin to a
    `model-1' isochron regression.}

\item{levels}{a vector with additional values to be displayed as
different background colours of the plot symbols.}

\item{clabel}{label of the colour legend}

\item{plateau.col}{a vector of two fill colours of the rectangles
used to mark the steps belonging to the age plateau.  If
\code{levels=NA}, then only the first colour is used. If
\code{levels} is a vector of numbers, then \code{bg} is used to
construct a colour ramp.}

\item{non.plateau.col}{if \code{plateau=TRUE}, the steps that do
NOT belong to the plateau are given a different colour.}

\item{sigdig}{the number of significant digits of the numerical
values reported in the title of the graphical output (only used
if \code{plateau=TRUE}).}

\item{line.col}{colour of the average age line}

\item{lwd}{width of the average age line}

\item{title}{add a title to the plot?}

\item{show.ci}{show a 100(1-\eqn{\alpha})\% confidence interval for
the plateau age as a grey band}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{hide}{vector with indices of aliquots that should be removed
from the plot.}

\item{exterr}{propagate the external (decay constant and
calibration factor) uncertainties?}

\item{i2i}{`isochron to intercept':
calculates the initial (aka `inherited',
`excess', or `common') \eqn{^{40}}Ar/\eqn{^{36}}Ar ratio from
an isochron fit. Setting \code{i2i} to \code{FALSE} uses the
default values stored in \code{settings('iratio',...)}}
}
\value{
If \code{plateau=TRUE}, returns a list with the following
    items:

\describe{
\item{mean}{a 3-element vector with:

\code{x}: the plateau mean

\code{s[x]}: the estimated standard deviation of \code{x}

\code{ci[x]}: the width of a 100(1-\eqn{\alpha})\% confidence interval of
\code{t} }

\item{disp}{a 3-element vector with:

\code{w}: the overdispersion, i.e. the standard deviation of the
Normal distribution that is assumed to describe the true ages.

\code{ll}: the width of the lower half of a 100(1-\eqn{\alpha})\%
confidence interval for the overdispersion

\code{ul}: the width of the upper half of a 100(1-\eqn{\alpha})\%
confidence interval for the overdispersion}

\item{df}{the degrees of freedom for the weighted mean plateau fit}

\item{mswd}{the mean square of the weighted deviates of the plateau}

\item{p.value}{the p-value of a Chi-square test with \eqn{df=n-2}
degrees of freedom, where \eqn{n} is the number of steps in the
plateau and 2 degrees of freedom have been removed to estimate the
mean and the dispersion.}

\item{fract}{the fraction of \eqn{^{39}}Ar contained in the
plateau}

\item{plotpar}{plot parameters for the weighted mean (see
\code{\link{weightedmean}}), which are not used in the age
spectrum}

\item{i}{indices of the steps that are retained for the plateau age
calculation}

}
}
\description{
Produces a plot of boxes whose widths correspond to the cumulative
amount of \eqn{^{39}}Ar (or any other variable), and whose
heights express the analytical uncertainties.  Only propagates the
analytical uncertainty associated with decay constants and
J-factors \emph{after} computing the plateau composition.
}
\details{
\code{IsoplotR} defines the `plateau age' as the weighted mean age
of the longest sequence (in terms of cumulative \eqn{^{39}}Ar
content) of consecutive heating steps that pass the modified
Chauvenet criterion (see \code{\link{weightedmean}}).  Note that
this definition is different (and simpler) than the one used by
\code{Isoplot} (Ludwig, 2003). However, it is important to mention
that all definitions of an age plateau are heuristic by nature and
should not be used for quantitative inference.
}
\examples{
data(examples)
agespectrum(examples$ArAr,ylim=c(0,80))
}
\seealso{
\code{\link{weightedmean}}
}
