% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errorellipse.R
\name{scatterplot}
\alias{scatterplot}
\title{Create a scatter plot with error ellipses or crosses}
\usage{
scatterplot(xy, xlim = NA, ylim = NA, alpha = 0.05,
  show.numbers = FALSE, show.ellipses = 1, levels = NA,
  clabel = "", ellipse.col = c("#00FF0080", "#FF000080"),
  fit = "none", add = FALSE, empty = FALSE, ci.col = "gray80",
  line.col = "black", lwd = 1, hide = NULL, omit = NULL,
  omit.col = NA, addcolourbar = TRUE, ...)
}
\arguments{
\item{xy}{matrix with columns X, sX, Y, sY(, rXY)}

\item{xlim}{(optional) two-element vector with the x-axis limits}

\item{ylim}{(optional) two-element vector with the y-axis limits}

\item{alpha}{the probability cutoff for the error ellipses}

\item{show.numbers}{logical flag (\code{TRUE} to show grain
numbers)}

\item{show.ellipses}{show the data as: \enumerate{ \item points
\item error ellipses \item error crosses }}

\item{levels}{a vector with additional values to be displayed as
different background colours within the error ellipses.}

\item{clabel}{label for the colour scale}

\item{ellipse.col}{a vector of two background colours for the error
ellipses. If \code{levels=NA}, then only the first colour will
be used. If \code{levels} is a vector of numbers, then
\code{ellipse.col} is used to construct a colour ramp.}

\item{fit}{the output of \code{york()} (optional).}

\item{add}{if \code{TRUE}, adds the points and lines to the
existing plot.}

\item{empty}{set up an empty plot with the right axis limits to fit
the data}

\item{ci.col}{the fill colour for the confidence interval of the
intercept and slope.}

\item{line.col}{colour of the regression line}

\item{lwd}{line width of the regression line}

\item{hide}{vector with indices of aliquots that should be removed
from the plot.}

\item{omit}{vector with indices of aliquots that should be plotted
but omitted from the isochron age calculation.}

\item{omit.col}{colour that should be used for the omitted
aliquots.}

\item{addcolourbar}{add a colour bar to display the colours used to
\code{levels}}

\item{...}{optional arguments to format the points and text.}
}
\description{
Takes bivariate data with (correlated) uncertainties as input and
produces a scatter plot with error ellipses or crosses as output.
(optionally) displays the linear fit on this diagram, and can show
a third variable as a colour scale.
}
\examples{
X <- c(1.550,12.395,20.445,20.435,20.610,24.900,
       28.530,50.540,51.595,86.51,106.40,157.35)
Y <- c(.7268,.7809,.8200,.8116,.8160,.8302,
       .8642,.9534,.9617,1.105,1.230,1.440)
sX <- X*0.02
sY <- Y*0.01
dat <- cbind(X,sX,Y,sY)
scatterplot(dat,fit=york(dat),show.ellipses=2)
}
