% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getelev.R
\name{getelev}
\alias{getelev}
\alias{downloadfile}
\title{Download an elevation raster from internet}
\source{
\url{http://topotools.cr.usgs.gov/gmted_viewer/}
}
\usage{
getelev(path = NULL, overwrite = FALSE, verbose = interactive())
}
\arguments{
\item{path}{A \var{string} indicating where to store the file on the hard
drive}

\item{overwrite}{A \var{logical} indicating if an existing file should be
re-downloaded}

\item{verbose}{A \var{logical} indicating whether information about the
progress of the procedure should be displayed or not while the function is
running. By default verbose is \code{TRUE} if users use an interactive R
session and \code{FALSE} otherwise. If a \var{numeric} is provided instead,
additional information about the download will be provided if the number is
greater than 1.}
}
\description{
The function \code{getelev} allows for the download of an elevation raster
from internet. It downloads the "Global Multi-resolution Terrain Elevation
Data 2010" from our server. The file was orifginally downloaded from: \cr
\url{http://topotools.cr.usgs.gov/gmted_viewer/} \cr and converted into a
\var{tif} file by us. The function \code{getelev} uses the generic function
\code{downloadfile} that can also be used to download directly other files.
This raster needs further processing with the function \code{\link{relevate}}
and can then be passed to \code{\link{isoscape}}.
}
\details{
If the argument "path" is not provided, the file will be stored in the
current working directory. The function can create new directories, so you
can also indicate a new path. If the package \pkg{\link[tools]{tools}} is
installed, the integrity of the elevation raster is tested after a call to
\code{\link{getelev}}. In case of corruption, try downloading the file again,
specifying overwrite = TRUE to overwrite the corrupted file.
}
\examples{

## To download the high resolution
## raster in your current working
## directory, just type:
## getelev()

}
