% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-mplus.R
\name{write_mplus_input}
\alias{write_mplus_input}
\title{Prepare an Mplus Input File}
\usage{
write_mplus_input(
  object = NULL,
  pseudoitems = NULL,
  data_file = NULL,
  fsco_file = NULL,
  save_fscores = FALSE,
  quadpts = NULL,
  estimator = NULL,
  link = NULL,
  analysis_list = list()
)
}
\arguments{
\item{object}{Object of class \code{irtree_model}. See \link{irtree_model} for more
information.}

\item{pseudoitems}{Data frame as returned from \code{\link[=irtree_recode]{irtree_recode()}}.}

\item{data_file}{String, the full file path of the data set.}

\item{fsco_file}{String, the file name used by Mplus to store the factor scores.}

\item{save_fscores}{Logical, whether to save FSCORES or not.}

\item{quadpts}{This is passed to argument 'INTEGRATION' of Mplus. Thus, it
may be an integer specifying the number of integration points for the Mplus
default of rectangular numerical integration (e.g., \code{quadpts = 15}). Or it
may be a string, which gives more fine grained control (e.g., \code{quadpts = "MONTECARLO(2000)"}).}

\item{estimator}{String, passed to argument 'ESTIMATOR' in Mplus.}

\item{link}{String, passed to argument 'LINK' in Mplus. Specifies
the link function.}

\item{analysis_list}{Named list of strings passed to Mplus' argument
ANALYSIS. See examples below.}
}
\value{
A list of of class \link[MplusAutomation:mplusObject]{MplusAutomation::mplusObject}
}
\description{
This is an internal function used by \code{\link[=irtree_fit_mplus]{irtree_fit_mplus()}}. It receives its
inputs from the model object and the data set and returns an object of class
\link[MplusAutomation:mplusObject]{MplusAutomation::mplusObject}.
}
\keyword{internal}
