/*
 * Decompiled with CFR 0.152.
 */
package j4r.multiprocess;

import j4r.lang.J4RSystem;
import j4r.multiprocess.AbstractIndependentProcess;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JavaProcess
extends AbstractIndependentProcess {
    private List<String> commands;
    private Map<String, String> environment;
    private File workingDirectory;
    private Map<JVM_OPTION, String> jvmOptions;

    public JavaProcess(List<String> commands, File workingDirectory, Map<String, String> environment) {
        this.init();
        this.commands.addAll(commands);
        this.workingDirectory = workingDirectory;
        this.environment = environment;
    }

    public JavaProcess(List<String> commands, File workingDirectory) {
        this(commands, workingDirectory, null);
    }

    @Override
    public String getName() {
        if (super.getName() == null) {
            try {
                return this.commands.get(0);
            }
            catch (Exception e) {
                return null;
            }
        }
        return super.getName();
    }

    public JavaProcess(List<String> commands) {
        this(commands, null, null);
    }

    public JavaProcess(List<String> commands, Map<String, String> environment) {
        this(commands, null, environment);
    }

    private void init() {
        this.commands = new ArrayList<String>();
        this.jvmOptions = new HashMap<JVM_OPTION, String>();
    }

    @Override
    protected Process createIndependentProcess() throws IOException {
        ArrayList<String> finalCommands = new ArrayList<String>();
        String javaPath = String.valueOf(System.getProperty("java.home")) + File.separator + "bin" + File.separator + "java";
        finalCommands.add(javaPath);
        if (!this.jvmOptions.isEmpty()) {
            for (String optionalCommand : this.jvmOptions.values()) {
                String[] stringArray = optionalCommand.split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String optCommand = stringArray[n2];
                    finalCommands.add(optCommand);
                    ++n2;
                }
            }
        }
        if (this.getName().endsWith(".jar")) {
            finalCommands.add("-jar");
        }
        finalCommands.addAll(this.commands);
        System.out.println(finalCommands);
        ProcessBuilder pb = new ProcessBuilder(finalCommands);
        pb.redirectErrorStream(true);
        if (this.workingDirectory != null) {
            pb.directory(this.workingDirectory);
        }
        if (this.environment != null && !this.environment.isEmpty()) {
            pb.environment().putAll(this.environment);
        }
        return pb.start();
    }

    public void setJVMMemory(int nbMegaJVM) {
        if (nbMegaJVM > 0) {
            this.jvmOptions.put(JVM_OPTION.Memory, "-Xmx" + nbMegaJVM + "m");
        }
    }

    public void setClassPath(String classPath) {
        if (classPath != null) {
            this.jvmOptions.put(JVM_OPTION.ClassPath, "-cp " + classPath);
        }
    }

    public void setOpenModuleForVersionsLaterThan8Enabled(boolean bool) {
        if (bool && J4RSystem.isCurrentJVMLaterThanThisVersion("1.8")) {
            this.jvmOptions.put(JVM_OPTION.OpenInternalLoader, "--add-opens java.base/jdk.internal.loader=ALL-UNNAMED");
        }
    }

    public void setOption(JVM_OPTION optionName, String option) {
        this.jvmOptions.put(optionName, option);
    }

    public Map<JVM_OPTION, String> getJVMSettings() {
        return this.jvmOptions;
    }

    public static enum JVM_OPTION {
        Memory,
        ClassPath,
        FileEncoding,
        SystemClassLoader,
        SplashWindow,
        OpenInternalLoader;

    }
}

