/*
 * Decompiled with CFR 0.152.
 */
package j4r.net.server;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;

public class ServerConfiguration
implements Serializable {
    private static final long serialVersionUID = 20111222L;
    private static final int MIN_PORT = 1024;
    private static final int MAX_PORT = 65535;
    protected final int numberOfClientThreadsPerReceiver;
    protected final int maxSizeOfWaitingList;
    protected final int[] listiningPorts;
    protected final int[] internalPorts;
    protected final boolean isLocal;
    protected final int key;
    protected final String wd;

    public ServerConfiguration(int numberOfClientThreadsPerReceiver, int maxSizeOfWaitingList, int[] listeningPorts, int[] internalPorts) {
        this(listeningPorts, internalPorts, numberOfClientThreadsPerReceiver, maxSizeOfWaitingList, false, -1, null);
    }

    private ServerConfiguration(int[] listeningPorts, int[] internalPorts, int numberOfClientThreadsPerReceiver, int maxSizeOfWaitingList, boolean isLocal, int key, String wd) {
        int port;
        this.isLocal = isLocal;
        if (numberOfClientThreadsPerReceiver < 0 || numberOfClientThreadsPerReceiver > 10) {
            throw new InvalidParameterException("Number of client threads should be between 1 and 10!");
        }
        this.numberOfClientThreadsPerReceiver = numberOfClientThreadsPerReceiver;
        if (listeningPorts == null) {
            throw new InvalidParameterException("The listeningPorts argument cannot be set to null!");
        }
        int[] nArray = listeningPorts;
        int n = listeningPorts.length;
        int n2 = 0;
        while (n2 < n) {
            port = nArray[n2];
            this.checkPort(port, "listening");
            ++n2;
        }
        this.listiningPorts = listeningPorts;
        nArray = internalPorts;
        n = internalPorts.length;
        n2 = 0;
        while (n2 < n) {
            port = nArray[n2];
            this.checkPort(port, "internal");
            ++n2;
        }
        this.internalPorts = internalPorts;
        this.maxSizeOfWaitingList = maxSizeOfWaitingList < 0 ? 0 : maxSizeOfWaitingList;
        this.key = key;
        this.wd = this.isLocalServer() ? (wd == null || !new File(wd).exists() ? System.getProperty("java.io.tmpdir") : wd) : null;
    }

    public ServerConfiguration(int[] listiningPorts, int[] internalPorts, int key, String wd) {
        this(listiningPorts, internalPorts, 1, 0, true, key, wd);
    }

    boolean isLocalServer() {
        return this.isLocal;
    }

    protected List<ServerSocket> createServerSockets() throws IOException {
        ArrayList<ServerSocket> sockets = new ArrayList<ServerSocket>();
        int[] nArray = this.listiningPorts;
        int n = this.listiningPorts.length;
        int n2 = 0;
        while (n2 < n) {
            int port = nArray[n2];
            sockets.add(new ServerSocket(port));
            ++n2;
        }
        return sockets;
    }

    private void checkPort(int port, String portType) {
        if (port != 0 && (port < 1024 || port > 65535)) {
            throw new InvalidParameterException("The " + portType + " port must be between " + 1024 + " and " + 65535 + " (or can be 0 for a random port)!");
        }
    }
}

