% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresholds.R
\name{get_thresholds}
\alias{get_thresholds}
\title{Get all (default) thresholds}
\usage{
get_thresholds(test_name, default = TRUE)
}
\arguments{
\item{test_name}{String. The name of the test to get.}

\item{default}{Boolean. (default is TRUE)
If TRUE, the default threshold will be returned.
If FALSE the current used thresholds.}
}
\description{
Get all (default) thresholds
}
\details{
If \code{test_name} is missing, all threshold will be returned.
}
\examples{

# Get all default thresholds
get_thresholds(default = TRUE)

# Get all current thresholds
get_thresholds(default = FALSE)

# Get all current thresholds
get_thresholds(test_name = "oos_mean", default = FALSE)

}
