/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.ibase.Common;

public class FileSelector
extends JFrame {
    public static final int OPEN = 0;
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    private FileDialog awtDialog = null;
    private JFileChooser swingChooser = null;
    private int type = 0;
    private Frame f;

    public FileSelector(Frame frame, String string, int n, String string2) {
        this.type = n;
        this.f = frame;
        if (Common.isMac()) {
            this.awtDialog = new FileDialog(frame, string, n);
            if (string2 != null) {
                this.awtDialog.setDirectory(string2);
            }
        } else {
            this.swingChooser = string2 != null ? new JFileChooser(string2) : new JFileChooser();
            this.swingChooser.setDialogTitle(string);
            this.swingChooser.setFileHidingEnabled(!JGRPrefs.showHiddenFiles);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (!Common.isMac()) {
            this.swingChooser.addActionListener(actionListener);
        }
    }

    public void setVisible(boolean bl) {
        if (Common.isMac()) {
            this.awtDialog.setVisible(true);
        } else if (this.type == 0) {
            this.swingChooser.showOpenDialog(this.f);
        } else if (this.type == 1) {
            this.swingChooser.showSaveDialog(this.f);
        } else {
            this.swingChooser.showDialog(this.f, "OK");
        }
    }

    public String getFile() {
        try {
            if (Common.isMac()) {
                return this.awtDialog.getFile();
            }
            return this.swingChooser.getSelectedFile().getName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getDirectory() {
        try {
            if (Common.isMac()) {
                return this.awtDialog.getDirectory();
            }
            return this.swingChooser.getCurrentDirectory().getAbsolutePath() + File.separator;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setFile(String string) {
        try {
            if (Common.isMac()) {
                this.awtDialog.setFile(string);
            } else {
                this.swingChooser.setSelectedFile(new File(string));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Component getSelector() {
        if (Common.isMac()) {
            return this.awtDialog;
        }
        return this.swingChooser;
    }
}

