/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JWindow;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.ibase.Common;

public class SplashScreen
extends JWindow
implements Runnable {
    private static final long serialVersionUID = 8996166449783183244L;
    private Thread thread;
    private final Dimension screenSize = Common.getScreenRes();
    private final Dimension splashSize = new Dimension(300, 200);
    private Image splash;
    private boolean contin = true;

    public SplashScreen() {
        try {
            this.splash = this.loadSplash("jgrsplash.jpg");
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
        this.setSize(this.splashSize);
        this.setLocation((this.screenSize.width - 300) / 2, (this.screenSize.height - 200) / 2);
        this.setBackground(Color.white);
        this.thread = new Thread(this);
    }

    public void paint(Graphics graphics) {
        try {
            if (this.splash != null) {
                graphics.drawImage(this.splash, 0, 0, this.splash.getWidth(this), this.splash.getHeight(this), this);
            }
            graphics.setFont(new Font("Dialog", 1, 26));
            graphics.drawString("JGR", 175, 40);
            graphics.setFont(new Font("Dialog", 1, 16));
            graphics.drawString("Java Gui for R", 150, 70);
            graphics.setFont(new Font("Dialog", 0, 11));
            graphics.drawString("Version: 1.7-10", 175, 85);
            graphics.setFont(new Font("Dialog", 2, 13));
            graphics.drawString("Markus Helbig", 163, 119);
            graphics.drawString("Simon Urbanek", 160, 134);
            graphics.drawString("Ian Fellows", 160, 149);
            graphics.setFont(new Font("Dialog", 0, 12));
            graphics.setColor(Color.blue);
            graphics.drawString("http://www.rosuda.org", 150, this.splashSize.height - 35);
            graphics.setColor(Color.black);
            graphics.setFont(new Font("Dialog", 0, 12));
            graphics.drawString("(c) 2003 - 2011, RoSuDa, Univ. Augsburg", 10, this.splashSize.height - 10);
            graphics.drawRect(0, 0, this.splashSize.width - 1, this.splashSize.height - 1);
        }
        catch (Exception exception) {
            graphics.setFont(new Font("Dialog", 0, 12));
            graphics.drawString("SplashScreen (something has gone wrong)", 10, 10);
            new ErrorMsg(exception);
        }
    }

    public Image loadSplash(String string) {
        URL uRL = this.getClass().getResource("/" + string);
        if (uRL == null) {
            uRL = this.getClass().getResource("/splash.jpg");
        }
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
        return image;
    }

    public void start() {
        this.setVisible(true);
        this.thread.start();
    }

    public void run() {
        while (this.contin) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                new ErrorMsg(exception);
            }
        }
    }

    public void stop() {
        this.setVisible(false);
        this.dispose();
        this.thread = null;
        this.contin = false;
    }
}

