/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine.JRI;

import org.rosuda.JRI.Mutex;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.JRI.Rengine;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPEnvironment;
import org.rosuda.REngine.REXPFactor;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPJavaReference;
import org.rosuda.REngine.REXPLanguage;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPNull;
import org.rosuda.REngine.REXPRaw;
import org.rosuda.REngine.REXPReference;
import org.rosuda.REngine.REXPS4;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REXPSymbol;
import org.rosuda.REngine.REXPUnknown;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineCallbacks;
import org.rosuda.REngine.REngineConsoleHistoryInterface;
import org.rosuda.REngine.REngineEvalException;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.REngineInputInterface;
import org.rosuda.REngine.REngineOutputInterface;
import org.rosuda.REngine.REngineUIInterface;
import org.rosuda.REngine.RList;

public class JRIEngine
extends REngine
implements RMainLoopCallbacks {
    static final int NILSXP = 0;
    static final int SYMSXP = 1;
    static final int LISTSXP = 2;
    static final int CLOSXP = 3;
    static final int ENVSXP = 4;
    static final int PROMSXP = 5;
    static final int LANGSXP = 6;
    static final int SPECIALSXP = 7;
    static final int BUILTINSXP = 8;
    static final int CHARSXP = 9;
    static final int LGLSXP = 10;
    static final int INTSXP = 13;
    static final int REALSXP = 14;
    static final int CPLXSXP = 15;
    static final int STRSXP = 16;
    static final int DOTSXP = 17;
    static final int ANYSXP = 18;
    static final int VECSXP = 19;
    static final int EXPRSXP = 20;
    static final int BCODESXP = 21;
    static final int EXTPTRSXP = 22;
    static final int WEAKREFSXP = 23;
    static final int RAWSXP = 24;
    static final int S4SXP = 25;
    public static final long requiredAPIversion = 266L;
    static JRIEngine jriEngine = null;
    Rengine rni = null;
    REngineCallbacks callbacks = null;
    Mutex rniMutex = null;
    long R_UnboundValue;
    long R_NilValue;
    public REXPReference globalEnv;
    public REXPReference emptyEnv;
    public REXPReference baseEnv;
    public REXPReference nullValueRef;
    public REXPNull nullValue;

    public static REngine createEngine() throws REngineException {
        if (jriEngine == null) {
            jriEngine = new JRIEngine();
        }
        return jriEngine;
    }

    public static REngine createEngine(String[] args, REngineCallbacks callbacks, boolean runREPL) throws REngineException {
        if (jriEngine != null) {
            throw new REngineException(jriEngine, "engine already running - cannot use extended constructor on a running instance");
        }
        jriEngine = new JRIEngine(args, callbacks, runREPL);
        return jriEngine;
    }

    public Rengine getRni() {
        return this.rni;
    }

    public JRIEngine() throws REngineException {
        this(new String[]{"--no-save"}, (REngineCallbacks)null, false);
    }

    public JRIEngine(String[] args) throws REngineException {
        this(args, (REngineCallbacks)null, false);
    }

    public JRIEngine(String[] args, RMainLoopCallbacks callbacks) throws REngineException {
        this(args, callbacks, callbacks != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRIEngine(String[] args, REngineCallbacks callbacks, boolean runREPL) throws REngineException {
        if (!Rengine.jriLoaded) {
            throw new REngineException(null, "Cannot load JRI native library");
        }
        if (Rengine.getVersion() < 266L) {
            throw new REngineException(null, "JRI API version is too old, update rJava/JRI to match the REngine API");
        }
        this.callbacks = callbacks;
        this.rni = new Rengine(args, runREPL, (RMainLoopCallbacks)(callbacks == null ? null : this));
        this.rniMutex = this.rni.getRsync();
        boolean obtainedLock = this.rniMutex.safeLock();
        try {
            if (!this.rni.waitForR()) {
                throw new REngineException(this, "Unable to initialize R");
            }
            JRIEngine jRIEngine = this;
            if (jRIEngine.rni.rniGetVersion() < 266L) {
                throw new REngineException(this, "JRI API version is too old, update rJava/JRI to match the REngine API");
            }
            this.globalEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(1)));
            this.R_NilValue = this.rni.rniSpecialObject(0);
            this.nullValueRef = new REXPReference((REngine)this, new Long(this.R_NilValue));
            this.emptyEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(2)));
            this.baseEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(3)));
            this.nullValue = new REXPNull();
            this.R_UnboundValue = this.rni.rniSpecialObject(4);
        }
        finally {
            if (obtainedLock) {
                this.rniMutex.unlock();
            }
        }
        lastEngine = this;
        if (jriEngine == null) {
            jriEngine = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRIEngine(String[] args, RMainLoopCallbacks callbacks, boolean runREPL) throws REngineException {
        if (!Rengine.jriLoaded) {
            throw new REngineException(null, "Cannot load JRI native library");
        }
        if (Rengine.getVersion() < 266L) {
            throw new REngineException(null, "JRI API version is too old, update rJava/JRI to match the REngine API");
        }
        this.rni = new Rengine(args, runREPL, callbacks);
        this.rniMutex = this.rni.getRsync();
        boolean obtainedLock = this.rniMutex.safeLock();
        try {
            if (!this.rni.waitForR()) {
                throw new REngineException(this, "Unable to initialize R");
            }
            JRIEngine jRIEngine = this;
            if (jRIEngine.rni.rniGetVersion() < 266L) {
                throw new REngineException(this, "JRI API version is too old, update rJava/JRI to match the REngine API");
            }
            this.globalEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(1)));
            this.R_NilValue = this.rni.rniSpecialObject(0);
            this.nullValueRef = new REXPReference((REngine)this, new Long(this.R_NilValue));
            this.emptyEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(2)));
            this.baseEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(3)));
            this.nullValue = new REXPNull();
            this.R_UnboundValue = this.rni.rniSpecialObject(4);
        }
        finally {
            if (obtainedLock) {
                this.rniMutex.unlock();
            }
        }
        lastEngine = this;
        if (jriEngine == null) {
            jriEngine = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRIEngine(Rengine eng) throws REngineException {
        if (!Rengine.jriLoaded) {
            throw new REngineException(null, "Cannot load JRI native library");
        }
        this.rni = eng;
        JRIEngine jRIEngine = this;
        if (jRIEngine.rni.rniGetVersion() < 265L) {
            throw new REngineException(this, "R JRI engine is too old - RNI API 1.9 (JRI 0.5) or newer is required");
        }
        this.rniMutex = this.rni.getRsync();
        boolean obtainedLock = this.rniMutex.safeLock();
        try {
            this.globalEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(1)));
            this.R_NilValue = this.rni.rniSpecialObject(0);
            this.nullValueRef = new REXPReference((REngine)this, new Long(this.R_NilValue));
            this.emptyEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(2)));
            this.baseEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(3)));
            this.nullValue = new REXPNull();
            this.R_UnboundValue = this.rni.rniSpecialObject(4);
        }
        finally {
            if (obtainedLock) {
                this.rniMutex.unlock();
            }
        }
        lastEngine = this;
        if (jriEngine == null) {
            jriEngine = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP parse(String text, boolean resolve) throws REngineException {
        REXP ref = null;
        boolean obtainedLock = this.rniMutex.safeLock();
        try {
            long pr = this.rni.rniParse(text, -1);
            if (pr == 0L || pr == this.R_NilValue) {
                throw new REngineException(this, "Parse error");
            }
            this.rni.rniPreserve(pr);
            ref = new REXPReference((REngine)this, new Long(pr));
            if (resolve) {
                try {
                    ref = this.resolveReference(ref);
                }
                catch (REXPMismatchException me) {
                    // empty catch block
                }
            }
        }
        finally {
            if (obtainedLock) {
                this.rniMutex.unlock();
            }
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP eval(REXP what, REXP where, boolean resolve) throws REngineException, REXPMismatchException {
        REXP ref = null;
        long rho = 0L;
        if (where != null && !where.isReference()) {
            if (!where.isEnvironment() || ((REXPEnvironment)where).getHandle() == null) {
                throw new REXPMismatchException(where, "environment");
            }
            rho = ((JRIPointer)((REXPEnvironment)where).getHandle()).pointer();
        } else if (where != null) {
            rho = (Long)((REXPReference)where).getHandle();
        }
        if (what == null) {
            throw new REngineException(this, "null object to evaluate");
        }
        if (!what.isReference()) {
            if (what.isExpression() || what.isLanguage()) {
                what = this.createReference(what);
            } else {
                throw new REXPMismatchException(where, "reference, expression or language");
            }
        }
        boolean obtainedLock = this.rniMutex.safeLock();
        try {
            long pr = this.rni.rniEval(((Long)((REXPReference)what).getHandle()).longValue(), rho);
            if (pr == 0L) {
                throw new REngineEvalException((REngine)this, "error during evaluation", -2);
            }
            this.rni.rniPreserve(pr);
            ref = new REXPReference((REngine)this, new Long(pr));
            if (resolve) {
                ref = this.resolveReference(ref);
            }
        }
        finally {
            if (obtainedLock) {
                this.rniMutex.unlock();
            }
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign(String symbol, REXP value, REXP env) throws REngineException, REXPMismatchException {
        long rho = 0L;
        if (env != null && !env.isReference()) {
            if (!env.isEnvironment() || ((REXPEnvironment)env).getHandle() == null) {
                throw new REXPMismatchException(env, "environment");
            }
            rho = ((JRIPointer)((REXPEnvironment)env).getHandle()).pointer();
        } else if (env != null) {
            rho = (Long)((REXPReference)env).getHandle();
        }
        if (value == null) {
            value = this.nullValueRef;
        }
        if (!value.isReference()) {
            value = this.createReference(value);
        }
        boolean obtainedLock = this.rniMutex.safeLock();
        boolean succeeded = false;
        try {
            succeeded = this.rni.rniAssign(symbol, ((Long)((REXPReference)value).getHandle()).longValue(), rho);
        }
        finally {
            if (obtainedLock) {
                this.rniMutex.unlock();
            }
        }
        if (!succeeded) {
            throw new REngineException(this, "assign failed (probably locked binding");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP get(String symbol, REXP env, boolean resolve) throws REngineException, REXPMismatchException {
        REXP ref = null;
        long rho = 0L;
        if (env != null && !env.isReference()) {
            if (!env.isEnvironment() || ((REXPEnvironment)env).getHandle() == null) {
                throw new REXPMismatchException(env, "environment");
            }
            rho = ((JRIPointer)((REXPEnvironment)env).getHandle()).pointer();
        } else if (env != null) {
            rho = (Long)((REXPReference)env).getHandle();
        }
        boolean obtainedLock = this.rniMutex.safeLock();
        try {
            long pr = this.rni.rniFindVar(symbol, rho);
            if (pr == this.R_UnboundValue || pr == 0L) {
                REXP rEXP = null;
                return rEXP;
            }
            this.rni.rniPreserve(pr);
            ref = new REXPReference((REngine)this, new Long(pr));
            if (resolve) {
                try {
                    ref = this.resolveReference(ref);
                }
                catch (REXPMismatchException me) {
                    // empty catch block
                }
            }
        }
        finally {
            if (obtainedLock) {
                this.rniMutex.unlock();
            }
        }
        return ref;
    }

    public REXP resolveReference(REXP ref) throws REngineException, REXPMismatchException {
        Object res = null;
        if (ref == null) {
            throw new REngineException(this, "resolveReference called on NULL input");
        }
        if (!ref.isReference()) {
            throw new REXPMismatchException(ref, "reference");
        }
        long ptr = (Long)((REXPReference)ref).getHandle();
        if (ptr == 0L) {
            return this.nullValue;
        }
        return this.resolvePointer(ptr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    REXP resolvePointer(long ptr) throws REngineException, REXPMismatchException {
        if (ptr == 0L) {
            return this.nullValue;
        }
        Object var3_2 = null;
        boolean obtainedLock = this.rniMutex.safeLock();
        try {
            int xt = this.rni.rniExpType(ptr);
            String[] an = this.rni.rniGetAttrNames(ptr);
            REXPList attrs = null;
            if (an != null && an.length > 0) {
                long jobj = 0L;
                String oclass = null;
                RList attl = new RList();
                for (int i = 0; i < an.length; ++i) {
                    REXP av;
                    long aptr = this.rni.rniGetAttr(ptr, an[i]);
                    if (aptr == 0L || aptr == this.R_NilValue) continue;
                    if (an[i].equals("jobj")) {
                        jobj = aptr;
                    }
                    if ((av = this.resolvePointer(aptr)) == null || av == this.nullValue) continue;
                    attl.put(an[i], av);
                    if (!an[i].equals("class") || !av.isString()) continue;
                    oclass = av.asString();
                }
                if (attl.size() > 0) {
                    attrs = new REXPList(attl);
                }
                if (jobj != 0L && oclass != null && (oclass.equals("jobjRef") || oclass.equals("jarrayRef") || oclass.equals("jrectRef"))) {
                    REXPJavaReference i = new REXPJavaReference(this.rni.rniXrefToJava(jobj), attrs);
                    return i;
                }
            }
            switch (xt) {
                case 0: {
                    REXPNull jobj = this.nullValue;
                    return jobj;
                }
                case 16: {
                    void var3_16;
                    String[] s = this.rni.rniGetStringArray(ptr);
                    REXPString rEXPString = new REXPString(s, attrs);
                    return var3_16;
                }
                case 13: {
                    void var3_5;
                    long levx;
                    void var3_16;
                    if (this.rni.rniInherits(ptr, "factor") && (levx = this.rni.rniGetAttr(ptr, "levels")) != 0L) {
                        String[] levels = null;
                        int rlt = this.rni.rniExpType(levx);
                        if (rlt == 16) {
                            levels = this.rni.rniGetStringArray(levx);
                            int[] ids = this.rni.rniGetIntArray(ptr);
                            REXPFactor rEXPFactor = new REXPFactor(ids, levels, attrs);
                        }
                    }
                    if (var3_5 != null) return var3_16;
                    REXPInteger rEXPInteger = new REXPInteger(this.rni.rniGetIntArray(ptr), attrs);
                    return var3_16;
                }
                case 14: {
                    void var3_16;
                    REXPDouble rEXPDouble = new REXPDouble(this.rni.rniGetDoubleArray(ptr), attrs);
                    return var3_16;
                }
                case 10: {
                    void var3_16;
                    int[] ba = this.rni.rniGetBoolArrayI(ptr);
                    byte[] b = new byte[ba.length];
                    for (int i = 0; i < ba.length; ++i) {
                        b[i] = ba[i] == 0 || ba[i] == 1 ? (byte)ba[i] : (byte)-128;
                    }
                    REXPLogical rEXPLogical = new REXPLogical(b, attrs);
                    return var3_16;
                }
                case 19: {
                    void var3_16;
                    long[] l = this.rni.rniGetVector(ptr);
                    REXP[] rl = new REXP[l.length];
                    long na = this.rni.rniGetAttr(ptr, "names");
                    String[] names = null;
                    if (na != 0L && this.rni.rniExpType(na) == 16) {
                        names = this.rni.rniGetStringArray(na);
                    }
                    for (int i = 0; i < l.length; ++i) {
                        rl[i] = this.resolvePointer(l[i]);
                    }
                    RList list = names == null ? new RList(rl) : new RList(rl, names);
                    REXPGenericVector rEXPGenericVector = new REXPGenericVector(list, attrs);
                    return var3_16;
                }
                case 24: {
                    void var3_16;
                    REXPRaw rEXPRaw = new REXPRaw(this.rni.rniGetRawArray(ptr), attrs);
                    return var3_16;
                }
                case 2: 
                case 6: {
                    void var3_16;
                    RList l = new RList();
                    long cdr = ptr;
                    while (cdr != 0L && cdr != this.R_NilValue) {
                        long car = this.rni.rniCAR(cdr);
                        long tag = this.rni.rniTAG(cdr);
                        String name = null;
                        if (this.rni.rniExpType(tag) == 1) {
                            name = this.rni.rniGetSymbolName(tag);
                        }
                        REXP val = this.resolvePointer(car);
                        if (name == null) {
                            l.add(val);
                        } else {
                            l.put(name, val);
                        }
                        cdr = this.rni.rniCDR(cdr);
                    }
                    REXPList rEXPList = xt == 6 ? new REXPLanguage(l, attrs) : new REXPList(l, attrs);
                    return var3_16;
                }
                case 1: {
                    void var3_16;
                    REXPSymbol rEXPSymbol = new REXPSymbol(this.rni.rniGetSymbolName(ptr));
                    return var3_16;
                }
                case 4: {
                    void var3_16;
                    if (ptr != 0L) {
                        this.rni.rniPreserve(ptr);
                    }
                    REXPEnvironment rEXPEnvironment = new REXPEnvironment(this, new JRIPointer(ptr, false));
                    return var3_16;
                }
                case 25: {
                    void var3_16;
                    REXPS4 rEXPS4 = new REXPS4(attrs);
                    return var3_16;
                }
                default: {
                    void var3_16;
                    REXPUnknown rEXPUnknown = new REXPUnknown(xt, attrs);
                    return var3_16;
                }
            }
        }
        finally {
            if (obtainedLock) {
                this.rniMutex.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP createReference(REXP value) throws REngineException, REXPMismatchException {
        if (value == null) {
            throw new REngineException(this, "createReference from a NULL value");
        }
        if (value.isReference()) {
            return value;
        }
        long ptr = this.createReferencePointer(value);
        if (ptr == 0L) {
            return null;
        }
        boolean obtainedLock = this.rniMutex.safeLock();
        try {
            this.rni.rniPreserve(ptr);
        }
        finally {
            if (obtainedLock) {
                this.rniMutex.unlock();
            }
        }
        return new REXPReference((REngine)this, new Long(ptr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long createReferencePointer(REXP value) throws REngineException, REXPMismatchException {
        if (value.isReference()) {
            REXPReference vref = (REXPReference)value;
            if (vref.getEngine() != this) {
                throw new REXPMismatchException(value, "reference (cross-engine reference is invalid)");
            }
            return (Long)vref.getHandle();
        }
        boolean obtainedLock = this.rniMutex.safeLock();
        int upp = 0;
        try {
            long ptr = 0L;
            if (value.isNull()) {
                long l = this.R_NilValue;
                return l;
            }
            if (value.isLogical()) {
                int[] v = value.asIntegers();
                for (int i = 0; i < v.length; ++i) {
                    v[i] = v[i] < 0 ? 2 : (v[i] == 0 ? 0 : 1);
                }
                ptr = this.rni.rniPutBoolArrayI(v);
            } else if (value.isInteger()) {
                ptr = this.rni.rniPutIntArray(value.asIntegers());
            } else if (value.isRaw()) {
                ptr = this.rni.rniPutRawArray(value.asBytes());
            } else if (value.isNumeric()) {
                ptr = this.rni.rniPutDoubleArray(value.asDoubles());
            } else if (value.isString()) {
                ptr = this.rni.rniPutStringArray(value.asStrings());
            } else if (value.isEnvironment()) {
                JRIPointer l = (JRIPointer)((REXPEnvironment)value).getHandle();
                if (l == null) {
                    long p = this.rni.rniParse("new.env(parent=baseenv())", 1);
                    ptr = this.rni.rniEval(p, 0L);
                } else {
                    ptr = l.pointer();
                }
            } else if (value.isPairList()) {
                boolean lang = value.isLanguage();
                RList rl = value.asList();
                ptr = this.R_NilValue;
                int j = rl.size();
                if (j == 0) {
                    ptr = this.rni.rniCons(this.R_NilValue, 0L, 0L, lang);
                } else {
                    for (int i = j - 1; i >= 0; --i) {
                        long vptr;
                        REXP v = rl.at(i);
                        String n = rl.keyAt(i);
                        long sn = 0L;
                        if (n != null) {
                            sn = this.rni.rniInstallSymbol(n);
                        }
                        if ((vptr = this.createReferencePointer(v)) == 0L) {
                            vptr = this.R_NilValue;
                        }
                        long ent = this.rni.rniCons(vptr, ptr, sn, i == 0 && lang);
                        this.rni.rniPreserve(ent);
                        this.rni.rniRelease(ptr);
                        ptr = ent;
                    }
                }
            } else if (value.isList()) {
                int init_upp = upp;
                RList rl = value.asList();
                long[] xl = new long[rl.size()];
                for (int i = 0; i < xl.length; ++i) {
                    REXP rv = rl.at(i);
                    if (rv == null || rv.isNull()) {
                        xl[i] = this.R_NilValue;
                        continue;
                    }
                    long lv = this.createReferencePointer(rv);
                    if (lv != 0L && lv != this.R_NilValue) {
                        this.rni.rniProtect(lv);
                        ++upp;
                    } else {
                        lv = this.R_NilValue;
                    }
                    xl[i] = lv;
                }
                ptr = this.rni.rniPutVector(xl);
                if (init_upp > upp) {
                    this.rni.rniUnprotect(upp - init_upp);
                    upp = init_upp;
                }
            } else {
                if (value.isSymbol()) {
                    long init_upp = this.rni.rniInstallSymbol(value.asString());
                    return init_upp;
                }
                if (value instanceof REXPJavaReference) {
                    Object jval = ((REXPJavaReference)value).getObject();
                    long jobj = this.rni.rniJavaToXref(jval);
                    this.rni.rniProtect(jobj);
                    long jobj_sym = this.rni.rniInstallSymbol("jobj");
                    long jclass_sym = this.rni.rniInstallSymbol("jclass");
                    String clname = "java/lang/Object";
                    if (jval != null) {
                        clname = jval.getClass().getName();
                        clname = clname.replace('.', '/');
                    }
                    long jclass = this.rni.rniPutString(clname);
                    this.rni.rniProtect(jclass);
                    long jobjRef = this.rni.rniPutString("jobjRef");
                    this.rni.rniProtect(jobjRef);
                    long ro = this.rni.rniEval(this.rni.rniLCons(this.rni.rniInstallSymbol("new"), this.rni.rniCons(jobjRef, this.rni.rniCons(jobj, this.rni.rniCons(jclass, this.R_NilValue, jclass_sym, false), jobj_sym, false))), 0L);
                    this.rni.rniUnprotect(3);
                    ptr = ro;
                }
            }
            if (ptr == this.R_NilValue) {
                long jval = ptr;
                return jval;
            }
            if (ptr != 0L) {
                REXPList att = value._attr();
                if (att == null || !att.isPairList()) {
                    long jobj = ptr;
                    return jobj;
                }
                RList al = att.asList();
                if (al == null || al.size() < 1 || !al.isNamed()) {
                    long xl = ptr;
                    return xl;
                }
                this.rni.rniProtect(ptr);
                ++upp;
                for (int i = 0; i < al.size(); ++i) {
                    long vptr;
                    REXP v = al.at(i);
                    String n = al.keyAt(i);
                    if (n == null || (vptr = this.createReferencePointer(v)) == 0L || vptr == this.R_NilValue) continue;
                    this.rni.rniSetAttr(ptr, n, vptr);
                }
                long l = ptr;
                return l;
            }
        }
        finally {
            if (upp > 0) {
                this.rni.rniUnprotect(upp);
            }
            if (obtainedLock) {
                this.rniMutex.unlock();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeReference(REXP ref) throws REngineException, REXPMismatchException {
        if (ref != null && ref.isReference()) {
            long ptr = (Long)((REXPReference)ref).getHandle();
            boolean obtainedLock = this.rniMutex.safeLock();
            try {
                this.rni.rniRelease(ptr);
            }
            finally {
                if (obtainedLock) {
                    this.rniMutex.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP getParentEnvironment(REXP env, boolean resolve) throws REngineException, REXPMismatchException {
        REXP ref = null;
        long rho = 0L;
        if (env != null && !env.isReference()) {
            if (!env.isEnvironment() || ((REXPEnvironment)env).getHandle() == null) {
                throw new REXPMismatchException(env, "environment");
            }
            rho = ((JRIPointer)((REXPEnvironment)env).getHandle()).pointer();
        } else if (env != null) {
            rho = (Long)((REXPReference)env).getHandle();
        }
        boolean obtainedLock = this.rniMutex.safeLock();
        try {
            long pr = this.rni.rniParentEnv(rho);
            if (pr == 0L || pr == this.R_NilValue) {
                REXP rEXP = null;
                return rEXP;
            }
            this.rni.rniPreserve(pr);
            ref = new REXPReference((REngine)this, new Long(pr));
            if (resolve) {
                ref = this.resolveReference(ref);
            }
        }
        finally {
            if (obtainedLock) {
                this.rniMutex.unlock();
            }
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP newEnvironment(REXP parent, boolean resolve) throws REXPMismatchException, REngineException {
        REXP ref = null;
        boolean obtainedLock = this.rniMutex.safeLock();
        try {
            long p;
            long rho = 0L;
            if (parent != null && !parent.isReference()) {
                if (!parent.isEnvironment() || ((REXPEnvironment)parent).getHandle() == null) {
                    throw new REXPMismatchException(parent, "environment");
                }
                rho = ((JRIPointer)((REXPEnvironment)parent).getHandle()).pointer();
            } else if (parent != null) {
                rho = (Long)((REXPReference)parent).getHandle();
            }
            if (rho == 0L) {
                rho = (Long)this.globalEnv.getHandle();
            }
            if ((p = this.rni.rniEval(this.rni.rniLCons(this.rni.rniInstallSymbol("new.env"), this.rni.rniCons(rho, this.R_NilValue, this.rni.rniInstallSymbol("parent"), false)), 0L)) != 0L) {
                this.rni.rniPreserve(p);
            }
            ref = new REXPReference((REngine)this, new Long(p));
            if (resolve) {
                ref = this.resolveReference(ref);
            }
        }
        finally {
            if (obtainedLock) {
                this.rniMutex.unlock();
            }
        }
        return ref;
    }

    public boolean close() {
        if (this.rni == null) {
            return false;
        }
        this.rni.end();
        return true;
    }

    public synchronized int tryLock() {
        int res = this.rniMutex.tryLock();
        return res == 1 ? 0 : (res == -1 ? 2 : 1);
    }

    public synchronized int lock() {
        return this.rniMutex.safeLock() ? 1 : 2;
    }

    public synchronized void unlock(int lockValue) {
        if (lockValue == 1) {
            this.rniMutex.unlock();
        }
    }

    public boolean supportsReferences() {
        return true;
    }

    public boolean supportsEnvironments() {
        return true;
    }

    public boolean supportsLocking() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXPReference createRJavaRef(Object o) throws REngineException {
        if (o == null) {
            return null;
        }
        REXPReference ref = null;
        boolean obtainedLock = this.rniMutex.safeLock();
        try {
            org.rosuda.JRI.REXP rx = this.rni.createRJavaRef(o);
            if (rx == null) {
                throw new REngineException(this, "Could not push java Object to R");
            }
            long p = rx.xp;
            this.rni.rniPreserve(p);
            ref = new REXPReference((REngine)this, new Long(p));
        }
        finally {
            if (obtainedLock) {
                this.rniMutex.unlock();
            }
        }
        return ref;
    }

    public void rWriteConsole(Rengine re, String text, int oType) {
        if (this.callbacks != null && this.callbacks instanceof REngineOutputInterface) {
            ((REngineOutputInterface)((Object)this.callbacks)).RWriteConsole(this, text, oType);
        }
    }

    public void rBusy(Rengine re, int which) {
        if (this.callbacks != null && this.callbacks instanceof REngineUIInterface) {
            ((REngineUIInterface)((Object)this.callbacks)).RBusyState(this, which);
        }
    }

    public synchronized String rReadConsole(Rengine re, String prompt, int addToHistory) {
        if (this.callbacks != null && this.callbacks instanceof REngineInputInterface) {
            return ((REngineInputInterface)((Object)this.callbacks)).RReadConsole(this, prompt, addToHistory);
        }
        try {
            this.wait();
        }
        catch (Exception e) {
            // empty catch block
        }
        return "";
    }

    public void rShowMessage(Rengine re, String message) {
        if (this.callbacks != null && this.callbacks instanceof REngineOutputInterface) {
            ((REngineOutputInterface)((Object)this.callbacks)).RShowMessage(this, message);
        }
    }

    public String rChooseFile(Rengine re, int newFile) {
        if (this.callbacks != null && this.callbacks instanceof REngineUIInterface) {
            return ((REngineUIInterface)((Object)this.callbacks)).RChooseFile(this, newFile == 0);
        }
        return null;
    }

    public void rFlushConsole(Rengine re) {
        if (this.callbacks != null && this.callbacks instanceof REngineOutputInterface) {
            ((REngineOutputInterface)((Object)this.callbacks)).RFlushConsole(this);
        }
    }

    public void rSaveHistory(Rengine re, String filename) {
        if (this.callbacks != null && this.callbacks instanceof REngineConsoleHistoryInterface) {
            ((REngineConsoleHistoryInterface)((Object)this.callbacks)).RSaveHistory(this, filename);
        }
    }

    public void rLoadHistory(Rengine re, String filename) {
        if (this.callbacks != null && this.callbacks instanceof REngineConsoleHistoryInterface) {
            ((REngineConsoleHistoryInterface)((Object)this.callbacks)).RLoadHistory(this, filename);
        }
    }

    class JRIPointer {
        long ptr;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        JRIPointer(long ptr, boolean preserve) {
            this.ptr = ptr;
            if (preserve && ptr != 0L && ptr != JRIEngine.this.R_NilValue) {
                boolean obtainedLock = JRIEngine.this.rniMutex.safeLock();
                try {
                    JRIEngine.this.rni.rniPreserve(ptr);
                }
                finally {
                    if (obtainedLock) {
                        JRIEngine.this.rniMutex.unlock();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            block7: {
                try {
                    if (this.ptr == 0L || this.ptr == JRIEngine.this.R_NilValue) break block7;
                    boolean obtainedLock = JRIEngine.this.rniMutex.safeLock();
                    try {
                        JRIEngine.this.rni.rniRelease(this.ptr);
                    }
                    finally {
                        if (obtainedLock) {
                            JRIEngine.this.rniMutex.unlock();
                        }
                    }
                }
                finally {
                    super.finalize();
                }
            }
        }

        long pointer() {
            return this.ptr;
        }
    }
}

