% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuum.R
\name{continuum.multigroup.iter}
\alias{continuum.multigroup.iter}
\title{The Joint and Individual Component Regression (JICO) algorithm}
\usage{
continuum.multigroup.iter(
  X.list,
  Y.list,
  lambda = 0,
  gam,
  rankJ,
  rankA,
  maxiter = 1000,
  conv = 1e-07,
  center.X = TRUE,
  scale.X = TRUE,
  center.Y = TRUE,
  scale.Y = TRUE,
  orthIndiv = FALSE,
  I.initial = NULL,
  sd = 0
)
}
\arguments{
\item{X.list}{The list of feature matrices from multiple groups.}

\item{Y.list}{The list of feature vectors from multiple groups.}

\item{lambda}{Deprecated. Regularization parameter if L2 penalization is used for CR.
JICO uses zero as default.}

\item{gam}{The gamma parameter in the CR algorithm. Set gam=0 for OLS model, gam=0.5 for PLS model,
gam >= 1e10 for PCR model.}

\item{rankJ}{The rank for the joint component.}

\item{rankA}{The ranks for individual components.}

\item{maxiter}{The maximum number of iterations to conduct before algorithm convergence.}

\item{conv}{The tolerance level for convergence.}

\item{center.X}{Boolean. If X should be preprocessed with centralization.}

\item{scale.X}{Boolean. If X should be preprocessed with scaling.}

\item{center.Y}{Boolean. If Y should be preprocessed with centralization.}

\item{scale.Y}{Boolean. If Y should be preprocessed with scaling.}

\item{orthIndiv}{Boolean. If we impose the orthogonality constraint on individual components.}

\item{I.initial}{The initial values for individual components.}

\item{sd}{The standard deviation used to generate random initial values for individual weight vectors.}
}
\value{
The estimated parameters from JICO.
}
\description{
This function iteratively solves the multi-group regression problem using the JICO algorithm.
JICO paper: Wang, P., Wang, H., Li, Q., Shen, D., & Liu, Y. (2022).
}
\examples{
set.seed(76)
X1 = MASS::mvrnorm(50, rep(0, 200), diag(200)) # covariates of the first group
X2 = MASS::mvrnorm(50, rep(0, 200), diag(200)) # covariates of the second group
X.list = list(X1, X2)

Y1 = matrix(stats::rnorm(50)) # responses for the first group
Y2 = matrix(stats::rnorm(50)) # responses for the second group
Y.list = list(Y1, Y2)

ml.JICO = continuum.multigroup.iter(
  X.list, Y.list, gam=1e10, rankJ=1, rankA=c(1, 1), 
  maxiter = 300
)
}
