% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuum.R
\name{cv.continnum.iter}
\alias{cv.continnum.iter}
\title{Fit JICO with cross-validation to tune hyperparameters}
\usage{
cv.continnum.iter(
  X.list,
  Y.list,
  lambda = 0,
  parameter.set,
  nfolds = 10,
  maxiter = 100,
  center.X = TRUE,
  scale.X = TRUE,
  center.Y = TRUE,
  scale.Y = TRUE,
  orthIndiv = FALSE,
  plot = FALSE,
  criteria = c("min", "1se"),
  sd = 0
)
}
\arguments{
\item{X.list}{The list of feature matrices from multiple groups.}

\item{Y.list}{The list of feature vectors from multiple groups.}

\item{lambda}{Deprecated. Regularization parameter if L2 penalization is used for CR.
JICO uses zero as default.}

\item{parameter.set}{The set of parameters to be tuned on. Containing choices of rankJ, rankA and gamma.}

\item{nfolds}{number of folds to perform CV}

\item{maxiter}{The maximum number of iterations to conduct before algorithm convergence.}

\item{center.X}{Boolean. If X should be preprocessed with centralization.}

\item{scale.X}{Boolean. If X should be preprocessed with scaling.}

\item{center.Y}{Boolean. If Y should be preprocessed with centralization.}

\item{scale.Y}{Boolean. If Y should be preprocessed with scaling.}

\item{orthIndiv}{Boolean. If we impose the orthogonality constraint on individual components.}

\item{plot}{Boolean. If we want to plot the rMSE vs different parameters}

\item{criteria}{criteria for selecting the best parameter.
Use "min" to choose the parameter giving the best performance.
Use "1se" to choose the simplest model that gives performance within 1se from the best one.}

\item{sd}{The standard deviation used to generate random initial values for individual weight vectors.}
}
\value{
The parameter from the parameter.set that fit the training data the best.
}
\description{
This function performs K-fold cross validations to select the best tuning parameters for JICO.
}
\examples{
set.seed(76)
X1 = MASS::mvrnorm(50, rep(0, 200), diag(200)) # covariates of the first group
X2 = MASS::mvrnorm(50, rep(0, 200), diag(200)) # covariates of the second group
X.list = list(X1, X2)

Y1 = matrix(stats::rnorm(50)) # responses for the first group
Y2 = matrix(stats::rnorm(50)) # responses for the second group
Y.list = list(Y1, Y2)

cv.parameter.set = parameter.set.G_2(
   maxrankA = 1, maxrankJ = 1, gamma = 1e10
) # enumerate the set of tuning parameters

cv.ml.JICO = cv.continnum.iter(
  X.list, Y.list, parameter.set = cv.parameter.set, 
  criteria = "min", nfold = 5, maxiter = 300
) # fit the model and use CV to find the best parameters
}
