% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psNormal.R
\name{psNormal}
\alias{psNormal}
\title{Smoothing scattered (normal) data using P-splines.}
\usage{
psNormal(
  x,
  y,
  xl = min(x),
  xr = max(x),
  nseg = 10,
  bdeg = 3,
  pord = 2,
  lambda = 1,
  wts = NULL,
  xgrid = 100
)
}
\arguments{
\item{x}{the vector for the continuous regressor of \code{length(y)} and the abcissae used to build the B-spline basis.}

\item{y}{the response vector, usually continuous data.}

\item{xl}{the number for the min along \code{x} (default is min(\code{x})) .}

\item{xr}{the number for the max along \code{x} (default is max(\code{x})).}

\item{nseg}{the number of evenly spaced segments between \code{xl} and \code{xr}.}

\item{bdeg}{the number of the degree of the basis, usually 1, 2 (default), or 3.}

\item{pord}{the number of the order of the difference penalty, usually 1, 2, or 3 (defalult).}

\item{lambda}{the (positive) number for the tuning parameter for the penalty (default 1).}

\item{wts}{the vector of general weights, default is 1; zero allowed.}

\item{xgrid}{a scalar or a vector that gives the \code{x} locations for prediction, useful for plotting.
If a scalar (default 100) is used then a uniform grid of this size along (\code{xl}, \code{xr}).}
}
\value{
\item{pcoeff}{a vector of length \code{n} of estimated P-spline coefficients.}
\item{muhat}{a vector of length \code{m} of smooth estimated means.}
\item{B}{a matrix of dimension \code{m} by \code{n} for the B-spline basis matrix.}
\item{wts}{a vector of length \code{m} of weights.}
\item{effdim}{estimated effective dimension.}
\item{ed_resid}{approximate df residual.}
\item{sigma}{square root of MSE.}
\item{cv}{standard error of leave-one-out prediction or root average PRESS.}
\item{nseg}{the number of B-spline segments.}
\item{bdeg}{the degree of the B-spline basis.}
\item{pord}{the order of the difference penalty.}
\item{lambda}{the positive tuning parameter.}
\item{xgrid}{gridded x values, useful for plotting.}
\item{ygrid}{gridded fitted mean values, useful for plotting.}
\item{se_eta}{gridded standard errors for the fitted mean values, useful for plotting.}
\item{P}{"half" of the penalty, such that \code{P'P= lambda D'D}.}
}
\description{
\code{psNormal} is used to smooth scattered (normal) data using P-splines (with identity link function).
}
\examples{
library(JOPS)
library(MASS)
data(mcycle)
x <- mcycle$times
y <- mcycle$accel
fit1 <- psNormal(x, y, nseg = 20, bdeg = 3, pord = 2, lambda = .8)
plot(fit1, se = 2, xlab = "Time (ms)", ylab = "Acceleration")
}
\references{
Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.

Eilers, P.H.C., Marx, B.D., and Durban, M. (2015).
Twenty years of P-splines, \emph{SORT}, 39(2): 149-186.
}
\author{
Paul Eilers and Brian Marx
}
