
#'
#' PCQDA_Train
#' 
#' PCQDA_Train is the train set of the PCQDA model. It consists of Cluster2, 
#' Age, MeanDNE.Apex, TotalDNE.TotalPolygonFaces, Proportion.DNEunder0.0001, 
#' and Proportion.DNEover0.6. The number of rows is 704. 
#'
#'
#' @export
#' 
PCQDA_Train<-{
  Cluster2 <- c(1, 1, 2, 2, 3, 3, 3, 2, 3, 2, 3, 3, 4, 4, 2, 3, 2, 3, 2, 3, 2, 2, 3, 3, 2, 2, 1, 3, 3, 3, 3, 2, 2, 3, 3, 3, 3, 2, 3, 3, 3, 2, 3, 2, 2, 2, 3, 2, 2, 2, 3, 3, 2, 2, 3, 3, 2, 2, 1, 2, 2, 2, 3, 2, 2, 2, 2, 3, 3, 2, 3, 3, 3, 1, 2, 3, 2, 2, 3, 2, 2, 2, 2, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 4, 2, 3, 2, 2, 2, 3, 3, 2, 2, 2, 2, 1, 1, 1, 2, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 3, 2, 2, 3, 3, 2, 1, 1, 1, 1, 3, 4, 2, 2, 2, 1, 2, 3, 2, 1, 2, 2, 3, 2, 3, 2, 2, 4, 1, 1, 2, 2, 2, 2, 3, 1, 1, 2, 2, 1, 1, 3, 1, 1, 1, 1, 1, 2, 1, 1, 2, 2, 2, 1, 1, 2, 2, 2, 1, 1, 3, 3, 3, 2, 2, 2, 2, 1, 2, 2, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 1, 1, 2, 2, 2, 2, 3, 2, 2, 1, 1, 2, 2, 2, 2, 2, 3, 2, 2, 2, 3, 2, 2, 2, 3, 2, 2, 2, 2, 1, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 3, 2, 3, 3, 
                3, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 3, 2, 3, 3, 1, 1, 2, 2, 2, 4, 2, 2, 3, 3, 2, 2, 2, 2, 2, 3, 2, 2, 3, 2, 2, 3, 3, 2, 3, 4, 2, 4, 2, 1, 1, 2, 2, 3, 3, 2, 1, 1, 2, 2, 2, 3, 2, 2, 2, 2, 2, 3, 3, 2, 3, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, 1, 1, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 1, 1, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 1, 2, 2, 2, 2, 1, 2, 
                3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 1, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 3, 2, 2, 2, 2, 3, 4, 3, 3, 2, 2, 3, 3, 2, 4, 4, 2, 4, 1, 4, 1, 3, 3, 1, 1, 2, 1, 1, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 3, 3, 4, 4, 2, 4, 2, 3, 3, 2, 3, 3, 3, 4, 4, 3, 2, 2, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 2, 2, 2, 3, 3, 3, 3, 2, 3, 3, 2, 4, 2, 2, 4, 4, 3, 3, 3, 3, 2, 4, 2, 2, 2, 3, 3, 2, 2, 2, 3, 3, 4, 2, 3, 3, 2, 2, 2, 3, 2, 2, 4, 2, 3, 3, 2, 2, 3, 3, 2, 2, 3, 2, 2, 3, 3, 3, 3, 3, 2, 2, 3, 3, 2, 2, 2, 4, 2, 2, 3, 3, 2, 2, 3, 3, 2, 2, 2, 3, 3, 4, 2, 2, 2, 3, 3, 3, 3, 4, 3, 3, 4, 2, 2, 2, 2, 2, 3, 3, 4, 2, 2, 4, 2, 3, 3, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 3)
  
  Age <- c(21, 21, 71, 71, 72, 78, 78, 72, 71, 71, 80, 79, 77, 77, 56, 68, 68, 70, 70, 67, 73, 33, 81, 81, 48, 48, 25, 78, 76, 93, 93, 60, 60, 75, 79, 79, 86, 70, 70, 79, 79, 68, 68, 68, 68, 46, 72, 72, 68, 68, 80, 80, 52, 52, 76, 76, 49, 49, 20, 35, 39, 39, 85, 69, 68, 32, 32, 77, 80, 45, 75, 75, 75, 29, 73, 73, 48, 48, 79, 57, 57, 51, 51, 93, 93, 76, 72, 62, 51, 51, 65, 68, 68, 89, 56, 75, 47, 54, 31, 77, 77, 39, 39, 47, 47, 25, 25, 28, 56, 34, 34, 61, 55, 55, 33, 33, 23, 47, 47, 38, 38, 26, 26, 29, 20, 20, 79, 66, 66, 89, 89, 72, 22, 22, 25, 25, 86, 94, 68, 42, 42, 20, 69, 69, 32, 26, 69, 69, 67, 34, 70, 33, 33, 87, 25, 25, 63, 35, 45, 35, 79, 20, 20, 35, 35, 22, 22, 76, 25, 23, 23, 26, 26, 45, 28, 28, 46, 46, 46, 20, 37, 37, 48, 48, 27, 27, 75, 75, 72, 72, 46, 46, 65, 23, 44, 44, 72, 72, 80, 75, 85, 85, 49, 49, 55, 64, 64, 40, 40, 59, 59, 58, 70, 45, 52, 52, 20, 20, 72, 69, 61, 61, 76, 
           43, 60, 28, 28, 35, 58, 62, 47, 47, 79, 52, 52, 73, 73, 52, 40, 40, 66, 66, 74, 50, 50, 29, 57, 50, 50, 82, 42, 42, 57, 60, 60, 70, 66, 70, 66, 78, 78, 69, 50, 69, 50, 84, 84, 56, 56, 65, 65, 77, 70, 75, 75, 27, 27, 53, 53, 54, 83, 54, 47, 83, 83, 68, 68, 60, 60, 68, 63, 52, 52, 75, 65, 65, 69, 71, 71, 69, 80, 31, 80, 60, 20, 20, 41, 41, 78, 78, 69, 30, 30, 54, 54, 44, 75, 44, 58, 57, 58, 69, 75, 75, 52, 82, 63, 57, 57, 83, 35, 65, 38, 53, 53, 39, 51, 51, 65, 65, 67, 62, 27, 27, 65, 65, 27, 68, 68, 65, 65, 54, 54, 57, 57, 33, 72, 72, 31, 31, 69, 72, 72, 52, 54, 51, 51, 70, 59, 59, 65, 65, 56, 56, 54, 54, 51, 84, 84, 56, 56, 74, 74, 50, 50, 68, 54, 54, 59, 59, 59, 59, 43, 43, 32, 50, 50, 67, 75, 49, 63, 61, 61, 31, 31, 89, 56, 56, 46, 34, 57, 62, 62, 33, 33, 68, 68, 52, 52, 53, 39, 38, 50, 62, 68, 68, 66, 66, 59, 59, 52, 52, 43, 47, 47, 45, 45, 70, 25, 68, 55, 28, 31, 54, 53, 53, 57, 57, 35, 51, 51, 26, 26, 39, 71, 71, 44, 25, 25, 22, 22, 45, 45, 23, 23, 32, 32, 30, 30, 49, 49, 64, 64, 62, 62, 
           49, 49, 35, 30, 30, 66, 66, 29, 38, 71, 48, 48, 25, 67, 67, 67, 68, 68, 64, 64, 45, 45, 39, 39, 44, 26, 26, 33, 44, 34, 34, 65, 65, 68, 80, 60, 48, 64, 48, 68, 65, 63, 63, 63, 89, 89, 83, 83, 43, 35, 90, 90, 67, 94, 94, 46, 81, 24, 81, 24, 92, 92, 21, 21, 43, 30, 30, 49, 76, 60, 60, 68, 38, 37, 37, 33, 33, 74, 86, 68, 68, 83, 83, 96, 96, 47, 95, 39, 75, 75, 49, 84, 81, 81, 83, 88, 88, 74, 74, 30, 49, 49, 52, 61, 61, 78, 78, 85, 85, 77, 77, 60, 60, 42, 76, 76, 85, 79, 45, 81, 81, 74, 89, 44, 44, 96, 96, 79, 85, 85, 68, 68, 78, 62, 62, 36, 92, 92, 68, 68, 56, 72, 83, 83, 62, 88, 80, 47, 47, 70, 67, 60, 60, 83, 60, 79, 79, 69, 69, 85, 85, 60, 60, 78, 51, 51, 82, 82, 81, 81, 85, 39, 39, 80, 80, 55, 66, 66, 96, 61, 61, 85, 85, 50, 50, 86, 86, 48, 48, 61, 85, 85, 85, 61, 71, 71, 88, 88, 75, 75, 76, 76, 82, 82, 66, 70, 68, 68, 68, 88, 88, 88, 44, 44, 79, 58, 93, 87, 65, 65, 49, 49, 76, 76, 55, 55, 55, 55, 83)
  
  MeanDNE.Apex <- c(0.026252, 0.029771, 0.037500, 0.036605, 0.039641, 0.039875, 0.036556, 0.038653, 0.043363, 0.037548, 0.040167, 0.044159, 0.042857, 0.026329, 0.033512, 0.042875, 0.038635, 0.041455, 0.037373, 0.048303, 0.034611, 0.028402, 0.054399, 0.037933, 0.030865, 0.028962, 0.024660, 0.037293, 0.037618, 0.040052, 0.039781, 0.037117, 0.028459, 0.045117, 0.038681, 0.042979, 0.041587, 0.037310, 0.043667, 0.040513, 0.041285, 0.033705, 0.041119, 0.043076, 0.043181, 0.031265, 0.031102, 0.037797, 0.033860, 0.034865, 0.036645, 0.032415, 0.037685, 0.027353, 0.037676, 0.034756, 0.027067, 0.030197, 0.029207, 0.032765, 0.027261, 0.025692, 0.036169, 0.036813, 0.031711, 0.028965, 0.031010, 0.036163, 0.039968, 0.025552, 0.036443, 0.037867, 0.035316, 0.033962, 0.040341, 0.042902, 0.037145, 0.036839, 0.040684, 0.033859, 0.027534, 0.029470, 0.034135, 0.049248, 0.040434, 0.038338, 0.037826, 0.037217, 0.033341, 0.031366, 0.034901, 0.036251, 0.035835, 0.048558, 0.033709, 0.032198, 0.034744, 0.034267, 0.031741, 0.042251, 0.036012, 0.035826, 
                    0.026972, 0.028629, 0.031604, 0.027411, 0.023636, 0.028862, 0.033071, 0.032443, 0.034857, 0.033771, 0.031168, 0.034759, 0.038296, 0.032553, 0.035445, 0.031393, 0.026558, 0.030897, 0.035365, 0.024281, 0.023683, 0.031685, 0.027524, 0.022206, 0.038136, 0.037741, 0.036623, 0.039293, 0.040294, 0.029836, 0.022208, 0.028935, 0.020166, 0.027855, 0.039693, 0.048044, 0.033854, 0.027570, 0.033375, 0.029837, 0.032137, 0.030431, 0.040651, 0.030917, 0.038655, 0.040210, 0.039131, 0.025555, 0.040704, 0.026102, 0.027938, 0.042649, 0.032622, 0.030900, 0.038671, 0.025552, 0.030966, 0.028897, 0.045101, 0.025058, 0.024491, 0.032037, 0.032519, 0.026281, 0.023612, 0.036589, 0.025893, 0.030758, 0.032572, 0.023789, 0.037636, 0.037386, 0.026274, 0.027844, 0.036103, 0.030258, 0.031288, 0.026077, 0.035541, 0.030039, 0.029419, 0.032473, 0.025483, 0.031911, 0.042017, 0.040552, 0.031426, 0.038136, 0.037183, 0.031317, 0.041740, 0.026987, 0.029933, 0.026662, 0.034797, 0.041185, 0.042193, 0.035762, 0.036596, 0.039853, 0.032541, 0.031803, 0.033169, 0.034372, 0.037328, 0.027410, 0.028869, 0.039875, 0.039987, 0.036237, 0.032045, 0.029582, 0.038985, 0.027303, 0.025239, 0.025520, 0.038712, 0.041696, 0.041877, 0.037843, 0.032322, 0.027557, 0.042304, 
                    0.033506, 0.031679, 0.025998, 0.037428, 0.033681, 0.033633, 0.033624, 0.034773, 0.033953, 0.031467, 0.039991, 0.040149, 0.030683, 0.031538, 0.029082, 0.033904, 0.040644, 0.032565, 0.037080, 0.038957, 0.032373, 0.034006, 0.037456, 0.030769, 0.040169, 0.033960, 0.031108, 0.036657, 0.032861, 0.030692, 0.038114, 0.035489, 0.037455, 0.036970, 0.039742, 0.036101, 0.036178, 0.035772, 0.037214, 0.032792, 0.037595, 0.036548, 0.030517, 0.031819, 0.030260, 0.034652, 0.052511, 0.041971, 0.036526, 0.039672, 0.026528, 0.024094, 0.030491, 0.035810, 0.032404, 0.034457, 0.034363, 0.030683, 0.040163, 0.040587, 0.039409, 0.035292, 0.028178, 0.032633, 0.032229, 0.039901, 0.030104, 0.037341, 0.034621, 0.039901, 0.035788, 0.038823, 0.034514, 0.044014, 0.039842, 0.035346, 0.031190, 0.039910, 0.035603, 0.025430, 0.030452, 0.030934, 0.029881, 0.036627, 0.044180, 0.037292, 0.031450, 0.025148, 0.037449, 0.037678, 0.036373, 0.034990, 0.030998, 0.028190, 0.035714, 0.028372, 0.030377, 0.040332, 0.037301, 0.032884, 0.038581, 0.036622, 0.031321, 0.034290, 0.036086, 0.028554, 0.026415, 0.036010, 0.030936, 0.030239, 0.035889, 0.037703, 0.033619, 0.033017, 0.036335, 0.041237, 0.037160, 0.031279, 0.024990, 0.040095, 0.038093, 0.024147, 0.037828, 0.034486, 0.036318, 0.032117, 0.031934, 0.028348, 0.037000, 0.027988, 0.028892, 0.033590, 0.038600, 0.028867, 0.024474, 0.034014, 0.042739, 0.035686, 0.029662, 0.028417, 0.034033, 0.031376, 0.039419, 0.035210, 0.032531, 0.033295, 0.040503, 0.031752, 0.030866, 0.032610, 0.030581, 0.036409, 0.046057, 0.032051, 0.035938, 0.033663, 0.033313, 0.030557, 0.026772, 0.034346, 0.029770, 0.036165, 0.033863, 0.033023, 0.039125, 0.035459, 0.035165, 0.032630, 0.031756, 0.030291, 0.032557, 0.034257, 0.031361, 0.030689, 0.031145, 0.041075, 0.036065, 0.034895, 0.024868, 0.027001, 0.042148, 0.035682, 0.034369, 
                    0.032679, 0.027098, 0.027548, 0.032668, 0.028955, 0.029083, 0.029867, 0.037057, 0.032148, 0.028971, 0.033373, 0.028585, 0.027014, 0.030120, 0.029597, 0.038804, 0.034572, 0.030727, 0.034632, 0.038422, 0.031631, 0.037187, 0.034182, 0.028169, 0.027911, 0.031634, 0.030715, 0.029029, 0.040849, 0.037811, 0.023709, 0.030545, 0.032418, 0.029458, 0.028725, 0.027860, 0.026916, 0.033761, 0.036739, 0.031246, 0.029918, 0.031173, 0.032883, 0.029700, 0.029067, 0.032089, 0.032644, 0.033050, 0.032542, 0.040234, 0.032928, 0.030630, 0.031976, 0.033018, 0.027989, 0.025887, 0.022913, 0.033003, 0.031608, 0.031978, 0.026694, 0.036911, 0.032975, 0.041933, 0.038028, 0.035823, 0.031245, 0.034940, 0.038384, 0.029156, 0.029884, 0.030359, 0.032159, 0.041832, 0.029855, 0.034134, 0.037540, 0.033914, 0.031701, 0.029964, 0.029259, 0.042660, 0.038354, 0.031715, 0.034164, 0.035026, 0.037522, 0.031230, 0.032165, 0.029665, 0.029109, 0.036881, 0.028387, 0.023200, 0.027529, 0.034672, 0.033502, 0.034185, 0.032711, 0.033994, 0.037029, 0.040013, 0.037992, 0.036382, 0.029660, 0.028582, 0.035601, 0.036066, 0.040075, 0.031707, 0.035978, 0.047798, 0.048041, 0.040829, 0.039435, 0.033651, 0.032418, 0.051794, 0.032669, 0.034996, 0.045232, 0.043656, 0.034522, 0.032132, 0.028567, 0.036967, 0.026203, 0.047955, 0.047766, 0.022237, 0.043581, 0.029050, 0.025793, 0.025122, 0.031559, 0.042238, 0.030621, 0.033049, 0.031969, 0.025781, 0.029095, 0.026887, 0.030296, 0.029691, 0.039690, 0.040800, 0.038413, 0.035623, 0.042810, 0.033255, 0.062042, 0.051777, 0.027355, 0.045832, 0.035712, 0.044737, 0.040157, 0.041592, 0.036075, 0.031701, 0.042318, 0.043157, 0.037244, 0.044799, 0.036302, 0.038958, 0.032236, 0.029351, 0.034323, 0.033089, 0.040379, 0.029056, 0.037924, 0.036937, 0.031852, 0.035093, 0.040154, 0.033745, 0.035765, 0.024141, 0.031108, 0.041570, 0.036827, 
                    0.033112, 0.030913, 0.034657, 0.039947, 0.037581, 0.039282, 0.053978, 0.036780, 0.032149, 0.049990, 0.044861, 0.037285, 0.037486, 0.038434, 0.041167, 0.037008, 0.039559, 0.035106, 0.037696, 0.026466, 0.039590, 0.036466, 0.030149, 0.037486, 0.038559, 0.042239, 0.041731, 0.036758, 0.028984, 0.035383, 0.040200, 0.032728, 0.029514, 0.033232, 0.024307, 0.032429, 0.036632, 0.041176, 0.036962, 0.039036, 0.043504, 0.036411, 0.036402, 0.039362, 0.045061, 0.028503, 0.036899, 0.039563, 0.037186, 0.026881, 0.036783, 0.047025, 0.044721, 0.041588, 0.035170, 0.029630, 0.033147, 0.046140, 0.036742, 0.030701, 0.030504, 0.036479, 0.043761, 0.034099, 0.036033, 0.049909, 0.039543, 0.033656, 0.029978, 0.046958, 0.037114, 0.034437, 0.035203, 0.032967, 0.046398, 0.057150, 0.043858, 0.038295, 0.038108, 0.040880, 0.046040, 0.040901, 0.035161, 0.037959, 0.035913, 0.038105, 0.041409, 0.036657, 0.030316, 0.038355, 0.042849, 0.037736, 0.041173, 0.043943, 0.039686, 0.043082, 0.036509, 0.027285, 0.049667, 0.029564, 0.034887, 0.041793, 0.034287, 0.036300, 0.035316, 0.032289, 0.041051, 0.037271, 0.029496, 0.034228, 0.030283, 0.031607, 0.035317)
  
  TotalDNE.TotalPolygonFaces <- c(0.020791, 0.036184, 0.025182, 0.022533, 0.028801, 0.024517, 0.026235, 0.027106, 0.026717, 0.023180, 0.023626, 0.022099, 0.034417, 0.038190, 0.019484, 0.023540, 0.021462, 0.028718, 0.024106, 0.021462, 0.028202, 0.013985, 0.023000, 0.026724, 0.016475, 0.023661, 0.015720, 0.031587, 0.028127, 0.027798, 0.027348, 0.025894, 0.027085, 0.030688, 0.026925, 0.025104, 0.029828, 0.024481, 0.027370, 0.029350, 0.028471, 0.021948, 0.027318, 0.020853, 0.020546, 0.017495, 0.025697, 0.023588, 0.020716, 0.024999, 0.027665, 0.030594, 0.019395, 0.014926, 0.028390, 0.028915, 0.018255, 0.017240, 0.018490, 0.015563, 0.014684, 0.015986, 0.025537, 0.028484, 0.021464, 0.014458, 0.017533, 0.032416, 0.030067, 0.021180, 0.023457, 0.022241, 0.027213, 0.019136, 0.025209, 0.030258, 0.018840, 0.015882, 0.023517, 0.023979, 
                                  0.024064, 0.022986, 0.020092, 0.035271, 0.032218, 0.022428, 0.028285, 0.019812, 0.019829, 0.019990, 0.028381, 0.020687, 0.026424, 0.040472, 0.026891, 0.019487, 0.018898, 0.017159, 0.016440, 0.025464, 0.032571, 0.016603, 0.015340, 0.022675, 0.015058, 0.015707, 0.018624, 0.019894, 0.023768, 0.015115, 0.015473, 0.022980, 0.025873, 0.019325, 0.015943, 0.017775, 0.016683, 0.020520, 0.024074, 0.018157, 0.019255, 0.011815, 0.014029, 0.013565, 0.017607, 0.014031, 0.023770, 0.026150, 0.028196, 0.029464, 0.032408, 0.027608, 0.015612, 0.016780, 0.014916, 0.017781, 0.031173, 0.037345, 0.026368, 0.019185, 0.016533, 0.013356, 0.025720, 0.027235, 0.019325, 0.014965, 0.020696, 0.029043, 0.028615, 0.021984, 0.025247, 0.017628, 0.016171, 
                                  0.027052, 0.014963, 0.013356, 0.021180, 0.020300, 0.020030, 0.016122, 0.024294, 0.018852, 0.019189, 0.014476, 0.013903, 0.016818, 0.021075, 0.017271, 0.016656, 0.016741, 0.022113, 0.018924, 0.027470, 0.020322, 0.018785, 0.017529, 0.017329, 0.021162, 0.016343, 0.015903, 0.019682, 0.014298, 0.024160, 0.023261, 0.014013, 0.015189, 0.021669, 0.022082, 0.030838, 0.022754, 0.021574, 0.022859, 0.020698, 0.016994, 0.016089, 0.023084, 0.031309, 0.027879, 0.026921, 0.033288, 0.029002, 0.032653, 0.018004, 0.024504, 0.022935, 0.022439, 0.021926, 0.018371, 0.016329, 0.024346, 0.023927, 0.022973, 0.030102, 0.023152, 0.022232, 0.019016, 0.016432, 0.018233, 0.023740, 0.021154, 0.025376, 0.020991, 0.027105, 0.015816, 0.030465, 0.023662, 0.023377, 0.022095, 0.028835, 0.027389, 0.017910, 0.024942, 0.034824, 0.018336, 0.023955, 0.022038, 0.035476, 0.023971, 0.019541, 0.016858, 0.023600, 0.022713, 0.021953, 0.021151, 0.021641, 0.016147, 0.027347, 0.016359, 0.025851, 0.030713, 0.016967, 0.018480, 0.023420, 0.030292, 0.021407, 0.029519, 0.021179, 0.027577, 0.024912, 0.027708, 0.029150, 0.024469, 0.017677, 0.020832, 0.013783, 0.025071, 0.027642, 0.019206, 0.022278, 0.022514, 0.026160, 0.029583, 0.026832, 0.018758, 0.030207, 0.020605, 0.012133, 0.026319, 0.015293, 0.021382, 0.031172, 0.026889, 0.019052, 0.028301, 0.030924, 0.027621, 0.026897, 0.024808, 0.024279, 0.019080, 0.027685, 0.023559, 0.024708, 0.024534, 0.024797, 0.028009, 0.029839, 0.029211, 0.029031, 0.023529, 0.026101, 0.019186, 0.029222, 0.019795, 0.012674, 0.017339, 0.014625, 0.023895, 0.023460, 0.029117, 0.023955, 0.018288, 0.017404, 0.023503, 0.024255, 0.017032, 0.028076, 0.017066, 0.016969, 0.024314, 0.023311, 0.029586, 0.029647, 0.023057, 0.017737, 0.025372, 0.026276, 0.024706, 0.019158, 0.029836, 0.021232, 0.023923, 0.017387, 0.017610, 0.018174, 0.021269, 0.024875, 0.017432, 0.025381, 0.024570, 0.029077, 0.019677, 0.017644, 0.017589, 0.025123, 0.023174, 0.019831, 0.024114, 0.026716, 0.020291, 0.027859, 0.025536, 0.025183, 0.024685, 0.020979, 0.012970, 0.024447, 0.017729, 0.015829, 0.012575, 0.022845, 0.029184, 0.029017, 0.021402, 0.025059, 0.023018, 
                                  0.021669, 0.027359, 0.019877, 0.021038, 0.026237, 0.027512, 0.022360, 0.021358, 0.025500, 0.018457, 0.022584, 0.034255, 0.029270, 0.024506, 0.020996, 0.022691, 0.028292, 0.023309, 0.018602, 0.025673, 0.018700, 0.017267, 0.022776, 0.023205, 0.014093, 0.023460, 0.016874, 0.020788, 0.020339, 0.021966, 0.021789, 0.024748, 0.026234, 0.024130, 0.024685, 0.020398, 0.025008, 0.017502, 0.019133, 0.032259, 0.027444, 0.019727, 0.024002, 0.018911, 0.021659, 0.025308, 0.025724, 0.018719, 0.017615, 0.024146, 0.029959, 0.018148, 0.017977, 0.020012, 0.017029, 0.023203, 0.019223, 0.024602, 0.026874, 0.028915, 0.022991, 0.021121, 0.028854, 0.025778, 0.022747, 0.022723, 0.023666, 0.018675, 0.021798, 0.013154, 0.024713, 0.021177, 0.019341, 0.029311, 0.026572, 0.015373, 0.016179, 0.024763, 0.024116, 0.027633, 0.020865, 0.023778, 0.016583, 0.022469, 0.025362, 0.017710, 0.016536, 0.018634, 0.025674, 0.024837, 0.020796, 0.014735, 0.014383, 0.015875, 0.013529, 0.023354, 0.023226, 0.015291, 0.016611, 0.019165, 0.018494, 0.013252, 0.017931, 0.018205, 0.025527, 0.025587, 0.028021, 0.022085, 0.016197, 0.022893, 0.028824, 0.018256, 0.016549, 0.013241, 0.027443, 0.026930, 0.015325, 0.016291, 0.026472, 0.019109, 0.015378, 0.014367, 0.024298, 0.023746, 0.022958, 0.023837, 0.028673, 0.025575, 0.021131, 0.015155, 0.016275, 0.022125, 0.020630, 0.019501, 0.019715, 0.028166, 0.017310, 0.013766, 0.021999, 0.015169, 0.021112, 0.027979, 0.022278, 0.024564, 0.028106, 0.023281, 0.017670, 0.016245, 0.029874, 0.027233, 0.027417, 0.023854, 0.021716, 0.026089, 0.043325, 0.031367, 0.024230, 0.014647, 0.014094, 0.030046, 0.026917, 0.022613, 0.031232, 0.033175, 0.016549, 0.031397, 0.017560, 0.029319, 0.020456, 0.025401, 0.030998, 0.015049, 0.013086, 0.020938, 0.011767, 0.021442, 0.023988, 0.027642, 0.027263, 0.027101, 0.026407, 0.020899, 0.013807, 
                                  0.020750, 0.012287, 0.012495, 0.027305, 0.029922, 0.027693, 0.029103, 0.026735, 0.030712, 0.055677, 0.041837, 0.022963, 0.027949, 0.019126, 0.024840, 0.025175, 0.024528, 0.032591, 0.028938, 0.032040, 0.025032, 0.020136, 0.026772, 0.025542, 0.026239, 0.019385, 0.021703, 0.021260, 0.022946, 0.026804, 0.021948, 0.027834, 0.030570, 0.028814, 0.029382, 0.031993, 0.042541, 0.027098, 0.027423, 0.016650, 0.027952, 0.023962, 0.030387, 0.028852, 0.019671, 0.027996, 0.023527, 0.021522, 0.032192, 0.023950, 0.018660, 0.026938, 0.032720, 0.029886, 0.031971, 0.027722, 0.036884, 0.024679, 0.024848, 0.021079, 0.024368, 0.021501, 0.028069, 0.024204, 0.024387, 0.025508, 0.022263, 0.023341, 0.024116, 0.019244, 0.022555, 0.027291, 0.024588, 0.016951, 0.016292, 0.020723, 0.025423, 0.021429, 0.018933, 0.045908, 0.020832, 0.029362, 0.029817, 0.027684, 0.026930, 0.029119, 0.029091, 0.025309, 0.020439, 0.026490, 0.026037, 0.025761, 0.023937, 0.029849, 0.027550, 0.041029, 0.031941, 0.015138, 0.022247, 0.021379, 0.023502, 0.022624, 0.024786, 
                                  0.018023, 0.032689, 0.026534, 0.023088, 0.025889, 0.032933, 0.027966, 0.025203, 0.029653, 0.023095, 0.026138, 0.025025, 0.020127, 0.029206, 0.029831, 0.038394, 0.021209, 0.027958, 0.023179, 0.032742, 0.027737, 0.029507, 0.027461, 0.022964, 0.022364, 0.027413, 0.029516, 0.023654, 0.027863, 0.028931, 0.025156, 0.024172, 0.029245, 0.033017, 0.031592, 0.015848, 0.015935, 0.033256, 0.019413, 0.032537, 0.032869, 0.023353, 0.025937, 0.023810, 0.022206, 0.028906, 0.028988, 0.021627, 0.021648, 0.022410, 0.023049, 0.024609)
  
  Proportion.DNEunder0.0001 <- c(0.006085, 0.004442, 0.004677, 0.005563, 0.004647, 0.004653, 0.004029, 0.004416, 0.004327, 0.004653, 0.005466, 0.004612, 0.002974, 0.003259, 0.005838, 0.004315, 0.004508, 0.004278, 0.004548, 0.004195, 0.004793, 0.004839, 0.004044, 0.004481, 0.005862, 0.005745, 0.006344, 0.004124, 0.003781, 0.003958, 0.003635, 0.004878, 0.004992, 0.004542, 0.004378, 0.004523, 0.004621, 0.004243, 0.004562, 0.004277, 0.004445, 0.004976, 0.004169, 0.004776, 0.004501, 0.007008, 0.004291, 0.004252, 0.004732, 0.005227, 0.004363, 0.004579, 0.004574, 0.004555, 0.004653, 0.005018, 0.005184, 0.005417, 0.006943, 0.005151, 0.006128, 0.005838, 0.003573, 0.004696, 0.004632, 0.005910, 0.005720, 0.003725, 0.003989, 0.005200, 0.003816, 0.004195, 0.004455, 0.005638, 0.004378, 0.004119, 0.005175, 0.005035, 0.004606, 0.004915, 0.004252, 0.004806, 0.005329, 0.002444, 0.004060, 0.004003, 0.004789, 0.004311, 0.005011, 0.005327, 0.005403, 0.004504, 0.004612, 0.003519, 0.005046, 0.004024, 0.005428, 0.004870, 0.005335, 0.004187, 0.004100, 0.005199, 0.005001, 0.005102, 0.005782, 0.005534, 0.005080, 0.005420, 0.005709, 0.005749, 
                                 0.006232, 0.004137, 0.005149, 0.005174, 0.004992, 0.005550, 0.006140, 0.005375, 0.005110, 0.004044, 0.005040, 0.006257, 0.006190, 0.005654, 0.006208, 0.006591, 0.004194, 0.004538, 0.004967, 0.004424, 0.004424, 0.004856, 0.005137, 0.005631, 0.004818, 0.005934, 0.003911, 0.002680, 0.004669, 0.005972, 0.004734, 0.006778, 0.004334, 0.004303, 0.005760, 0.006317, 0.004303, 0.005923, 0.003941, 0.005179, 0.003887, 0.005061, 0.005871, 0.004743, 0.005472, 0.005383, 0.005200, 0.005049, 0.005228, 0.006178, 0.004286, 0.005323, 0.006411, 0.005316, 0.005715, 0.006105, 0.008081, 0.004603, 0.005163, 0.005407, 0.006493, 0.005782, 0.007231, 0.005926, 0.006473, 0.006646, 0.005692, 0.003745, 0.005789, 0.006383, 0.006954, 0.005491, 0.005323, 0.005404, 0.005850, 0.005795, 0.004564, 0.004762, 0.004318, 0.004363, 0.004671, 0.004982, 0.004963, 0.005904, 0.005722, 0.004154, 0.004098, 0.003955, 0.004358, 0.003618, 0.004446, 0.004001, 0.005505, 0.005368, 0.005076, 0.005448, 0.005155, 0.003566, 0.005084, 0.004334, 0.004394, 0.005076, 0.004171, 0.005870, 0.004783, 0.004514, 0.005758, 0.006333, 0.004324, 0.004166, 0.004684, 0.005149, 0.004373, 0.005290, 0.005968, 0.005386, 0.004697, 0.005298, 0.004229, 0.004308, 0.004612, 0.005044, 0.004149, 0.004880, 0.005177, 0.004204, 0.003112, 0.005787, 0.005370, 0.006069, 0.003993, 0.004345, 0.004350, 0.003438, 0.005317, 0.005050, 0.004922, 0.005695, 0.005927, 0.004410, 0.005532, 0.005518, 0.005183, 0.004654, 0.004310, 0.005721, 0.004218, 0.004536, 0.004245, 0.004627, 0.003680, 0.005735, 0.004336, 0.005647, 0.004083, 0.004190, 0.003750, 0.003746, 0.004414, 0.004999, 0.004959, 0.004180, 0.005164, 0.003784, 0.004248, 0.005960, 0.005888, 0.004964, 0.004098, 0.005115, 0.004456, 0.004936, 0.005291, 0.004399, 0.004511, 0.004438, 0.005104, 0.004976, 0.005049, 0.004736, 0.004149, 0.005196, 0.005741, 
                                 0.004049, 0.004607, 0.005644, 0.004086, 0.003866, 0.004603, 0.003919, 0.004083, 0.004922, 0.005076, 0.004654, 0.006329, 0.006357, 0.006746, 0.005743, 0.004613, 0.004790, 0.004201, 0.005312, 0.004894, 0.005608, 0.005234, 0.004854, 0.005337, 0.004752, 0.005307, 0.005122, 0.004969, 0.004703, 0.004536, 0.004406, 0.004451, 0.003885, 0.005082, 0.005089, 0.004648, 0.004280, 0.005551, 0.004658, 0.005478, 0.005127, 0.004586, 0.005383, 0.005784, 0.005535, 0.004464, 0.004676, 0.004578, 0.004449, 0.005733, 0.006396, 0.004921, 0.004734, 0.005620, 0.004750, 0.004348, 0.004183, 0.004912, 0.005791, 0.005784, 0.004397, 0.005063, 0.005740, 0.004683, 0.004684, 0.005089, 0.005812, 0.004274, 0.004999, 0.005745, 0.005222, 0.006078, 0.005045, 0.004492, 0.004851, 0.005179, 0.004804, 0.004536, 0.004958, 0.004725, 0.004689, 0.005469, 0.005242, 0.005359, 0.003977, 0.004066, 0.005669, 0.005496, 0.004101, 0.004664, 0.005812, 0.005865, 0.004211, 0.005028, 0.004477, 0.004375, 0.005092, 0.005567, 0.004910, 0.005790, 0.004817, 0.005190, 0.005335, 0.005330, 0.004669, 0.004482, 0.005460, 0.004957, 0.005245, 0.004936, 0.005087, 0.005630, 0.004392, 0.006263, 0.005683, 0.005282, 0.005352, 0.005591, 0.005388, 0.005092, 0.005373, 0.005309, 0.004830, 0.004392, 0.004643, 0.004461, 0.005632, 0.004270, 0.005357, 0.004463, 0.004991, 0.004938, 0.004291, 0.004135, 0.004692, 0.005310, 0.005433, 0.005173, 0.005180, 0.005767, 0.005006, 0.004554, 0.005221, 0.005649, 0.005057, 0.004969, 0.005256, 0.005340, 0.005148, 0.005650, 0.004852, 0.005506, 0.005286, 0.004638, 0.004741, 0.005346, 0.005575, 0.005490, 0.005821, 0.006071, 0.005500, 0.004754, 0.004783, 0.005210, 0.005377, 0.007020, 0.006771, 0.006103, 0.005351, 0.005912, 0.005655, 0.005135, 0.005369, 0.005607, 0.005970, 0.005421, 0.005286, 0.005469, 0.004590, 0.004494, 0.004203, 0.004818, 0.004633, 0.005270, 0.005510, 0.006200, 0.005306, 0.004746, 0.004917, 0.005744, 0.005950, 0.005079, 0.005422, 0.005575, 0.005888, 0.004937, 0.004016, 0.005037, 0.004503, 0.004789, 0.004941, 0.004758, 0.005508, 0.006026, 0.005595, 0.005413, 0.005721, 0.003793, 0.005145, 0.005292, 0.006481, 0.005819, 0.006043, 
                                 0.004709, 0.004701, 0.004783, 0.003833, 0.006423, 0.004640, 0.005215, 0.004419, 0.004525, 0.005016, 0.004661, 0.004811, 0.004715, 0.003402, 0.002331, 0.003748, 0.003813, 0.005255, 0.005888, 0.004118, 0.003047, 0.004835, 0.004197, 0.003735, 0.004982, 0.004845, 0.006071, 0.004067, 0.005666, 0.004362, 0.003494, 0.006113, 0.008853, 0.004897, 0.006303, 0.003950, 0.005708, 0.004390, 0.005574, 0.004406, 0.004483, 0.005076, 0.006297, 0.005743, 0.005863, 0.005106, 0.004596, 0.002613, 0.004882, 0.004955, 0.003993, 0.004256, 0.002920, 0.003280, 0.005286, 0.003282, 0.004738, 0.004982, 0.004675, 0.004640, 0.004609, 0.003913, 0.004266, 0.004583, 0.004184, 0.004355, 0.004787, 0.004985, 0.005139, 0.004575, 0.005241, 0.004976, 0.004707, 0.004346, 0.004765, 0.004706, 0.003706, 0.004728, 0.004015, 0.003282, 0.005180, 0.005385, 0.005214, 0.004492, 0.004548, 0.003585, 0.004674, 0.005818, 0.004046, 0.003830, 0.004615, 0.003309, 0.005667, 0.005981, 0.003686, 0.005036, 0.004314, 0.004755, 0.004193, 0.003546, 0.004378, 0.004100, 0.005488, 0.004657, 0.005440, 0.004367, 0.003977, 0.005109, 0.004215, 0.004889, 0.003870, 0.004161, 0.004429, 0.004673, 0.004074, 0.004339, 0.005412, 0.005014, 0.004662, 0.004089, 0.004893, 0.004883, 0.003074, 0.004750, 0.004283, 0.004465, 0.004896, 0.004688, 0.003790, 0.004044, 0.005548, 0.004986, 0.005718, 0.004259, 0.004933, 0.003939, 0.003609, 0.004182, 0.003885, 0.004192, 0.005040, 0.005039, 0.004058, 
                                 0.003973, 0.004933, 0.004927, 0.004550, 0.004167, 0.004722, 0.004625, 0.003957, 0.004378, 0.005895, 0.005618, 0.003822, 0.003395, 0.005171, 0.005132, 0.004366, 0.004484, 0.004222, 0.003124, 0.005524, 0.004793, 0.004691, 0.002739, 0.004579, 0.004399, 0.004636, 0.005497, 0.004131, 0.004336, 0.004640, 0.004984, 0.004823, 0.004514, 0.004893, 0.004355, 0.004565, 0.004574, 0.003571, 0.006085, 0.005476, 0.003259, 0.005418, 0.003647, 0.004214, 0.004677, 0.004731, 0.005274, 0.004915, 0.004622, 0.004651, 0.004618, 0.004970, 0.004926, 0.004964, 0.004188) 
  Proportion.DNEover0.6 <- c(0.000756, 0.000645, 0.001932, 0.001733, 0.001919, 0.001845, 0.002030, 0.001713, 0.002097, 0.001903, 0.001704, 0.001918, 0.002084, 0.003679, 0.001483, 0.001818, 0.001611, 0.001912, 0.001527, 0.001622, 0.001668, 0.000936, 0.001946, 0.002675, 0.001278, 0.001259, 0.000840, 0.001583, 0.001538, 0.001874, 0.002995, 0.001703, 0.001704, 0.001843, 0.001830, 0.002241, 0.001779, 0.001726, 0.001719, 0.001657, 0.002148, 0.001994, 0.001785, 0.001785, 0.002018, 0.001283, 0.001818, 0.001937, 0.001446, 0.001888, 0.001951, 0.001684, 0.001365, 0.001390, 0.002040, 0.001798, 0.001294, 0.000713, 0.000738, 0.000947, 0.001057, 0.001056, 0.002015, 0.001627, 0.001781, 0.001034, 0.000843, 0.001836, 0.001950, 0.001270, 0.001895, 0.001901, 0.001664, 0.000851, 0.001505, 0.001802, 0.001249, 0.001485, 0.001857, 0.001597, 0.001702, 0.001204, 0.001398, 0.002029, 0.002157, 0.001688, 0.001614, 0.001490, 0.001308, 0.001309, 0.001950, 0.001891, 0.001973, 0.004488, 0.001849, 0.001245, 0.001445, 0.001316, 0.001025, 0.001833, 0.001821, 0.001290, 0.001050, 0.001287, 0.001492, 0.000851, 0.000856, 0.000853, 0.001413, 0.001071, 0.000880, 0.001596, 0.001837, 0.001438, 0.000922, 0.001046, 0.000722, 0.001263, 0.001071, 0.001140, 0.001047, 0.000834, 0.000822, 0.000870, 0.000584, 0.002772, 0.001669, 0.001704, 0.001381, 0.001900, 0.001900, 0.001704, 0.000752, 0.000807, 0.000813, 0.000898, 0.001740, 0.003464, 0.001685, 0.001256, 0.001164, 0.000740, 0.001624, 0.001991, 0.001134, 0.000677, 0.001991, 0.001381, 0.001612, 0.001512, 0.001510, 0.000928, 0.000952, 0.001743, 0.000824, 0.000832, 0.000970, 0.001512, 0.001064, 0.001046, 0.002142, 
                             0.000722, 0.001455, 0.001202, 0.001148, 0.000744, 0.000731, 0.001547, 0.000845, 0.000713, 0.000732, 0.000813, 0.002455, 0.001291, 0.000820, 0.000813, 0.001261, 0.001406, 0.001292, 0.000797, 0.001034, 0.001038, 0.001442, 0.001266, 0.000781, 0.000865, 0.002072, 0.001831, 0.001763, 0.001734, 0.001237, 0.001323, 0.001476, 0.000711, 0.001064, 0.001173, 0.001736, 0.001723, 0.001808, 0.002040, 0.002265, 0.002139, 0.001291, 0.001327, 0.001469, 0.001522, 0.001893, 0.001332, 0.001058, 0.001371, 0.001422, 0.001469, 0.001830, 0.001251, 0.001397, 0.001593, 0.000750, 0.000718, 0.001717, 0.001580, 0.001682, 0.001599, 0.002074, 0.001143, 0.000875, 0.001039, 0.001388, 0.001046, 0.001521, 0.001437, 0.001410, 0.001262, 0.001721, 0.001364, 0.001309, 0.001754, 0.003184, 0.001371, 0.001313, 0.001224, 0.002216, 0.001630, 0.001733, 0.001347, 0.001315, 0.000837, 0.001423, 0.001703, 0.001213, 0.002117, 0.001046, 0.001089, 0.001429, 0.002153, 0.001588, 0.001344, 0.001735, 0.001626, 0.001737, 0.001824, 0.002102, 0.001336, 0.001431, 0.001480, 0.002001, 0.002320, 0.002336, 0.001476, 0.001488, 0.001584, 0.001713, 0.001839, 0.001636, 0.001872, 0.001757, 0.000850, 0.000858, 0.001366, 0.001373, 0.001866, 0.001465, 0.001928, 0.001323, 0.001807, 0.001927, 0.001626, 0.001363, 0.001521, 0.001274, 0.001530, 0.001538, 0.000838, 0.001378, 0.002074, 0.001411, 0.001635, 0.001625, 0.001733, 0.001628, 0.001824, 0.001815, 0.002094, 0.000874, 0.001523, 0.000735, 0.000726, 0.001291, 0.001147, 0.001834, 0.001527, 0.001802, 0.000920, 0.000848, 0.001395, 0.001296, 0.001184, 0.001176, 0.001523, 0.001408, 0.001484, 0.001446, 0.001450, 0.001861, 0.001561, 0.001317, 0.001989, 0.001584, 0.001416, 0.001553, 0.001663, 0.000821, 0.001635, 0.001042, 0.001181, 0.001219, 0.001228, 0.001414, 0.001607, 0.001330, 0.001163, 0.001610, 0.001521, 0.000992, 0.001016, 0.001922, 0.001599, 0.000815, 0.001602, 0.001535, 0.001437, 0.001919, 0.001386, 0.001682, 0.001403, 0.001352, 0.000934, 0.001483, 0.001872, 0.000928, 0.000941, 0.001613, 0.002002, 0.001461, 0.001458, 0.001394, 0.001396, 0.001491, 0.001715, 0.001491, 0.001498, 0.001640, 0.001933, 0.001411, 0.001183, 
                             0.001482, 0.001372, 0.001121, 0.001959, 0.001950, 0.001396, 0.001596, 0.001761, 0.001734, 0.001359, 0.001268, 0.001622, 0.001659, 0.001505, 0.001355, 0.001410, 0.001479, 0.001443, 0.001411, 0.001215, 0.001078, 0.001326, 0.001322, 0.001538, 0.001843, 0.001355, 0.001534, 0.001528, 0.001542, 0.000929, 0.000934, 0.001777, 0.001341, 0.001352, 0.001284, 0.000928, 0.001421, 0.001678, 0.001568, 0.001051, 0.000946, 0.001622, 0.001777, 0.001516, 0.001510, 0.001304, 0.001044, 0.001061, 0.001397, 0.001529, 0.001604, 0.001734, 0.001632, 0.002962, 0.001485, 0.001401, 0.001279, 0.001477, 0.001064, 0.001243, 0.001008, 0.001315, 0.001225, 0.000871, 0.001917, 0.001700, 0.001038, 0.000819, 0.000473, 0.001279, 0.001073, 0.001391, 0.001313, 0.001532, 0.001164, 0.001376, 0.001342, 0.000819, 0.000863, 0.001070, 0.001681, 0.001461, 0.001059, 0.000811, 0.000811, 0.000757, 0.000741, 0.001272, 0.001383, 0.000715, 0.000723, 0.000922, 0.000949, 0.000928, 0.001041, 0.001262, 0.001423, 0.001524, 0.001467, 0.001872, 0.001579, 0.001255, 0.001259, 0.001014, 0.000843, 0.000943, 0.001654, 0.001666, 0.000816, 0.001038, 0.001719, 0.001276, 0.001230, 0.000863, 0.001354, 0.001624, 0.001621, 0.001987, 0.001553, 0.001525, 0.001544, 0.001356, 0.001367, 0.001295, 0.001057, 0.001062, 0.000865, 0.000817, 0.000980, 0.001180, 0.000925, 0.000939, 0.001624, 0.001644, 0.001699, 0.001930, 0.001591, 0.001282, 0.001299, 0.001238, 0.001613, 0.001556, 0.001544, 0.001600, 0.001547, 0.001070, 0.002545, 0.001824, 0.001958, 0.001179, 0.001156, 0.002149, 0.002225, 0.001387, 0.002072, 0.002047, 0.001275, 0.000809, 0.001927, 0.000848, 0.002136, 0.002448, 0.002123, 0.000471, 0.000739, 0.001094, 0.000937, 0.001059, 0.001331, 0.001990, 0.001379, 0.001445, 0.001613, 0.001050, 0.001062, 0.001021, 0.000972, 0.000960, 0.002114, 0.002148, 0.001404, 0.001946, 0.001942, 0.001943, 0.005121, 0.003917, 0.001252, 0.002461, 0.001067, 0.001720, 0.001626, 0.001431, 0.002383, 0.001707, 0.002089, 0.001033, 0.002126, 0.002469, 0.001700, 0.002014, 0.001024, 0.001063, 0.001179, 0.001440, 0.001528, 0.001635, 0.001825, 0.001836, 0.002059, 0.001962, 0.001884, 0.002855, 0.001986, 0.001421, 0.001056, 0.001714, 0.001808, 0.002326, 0.001620, 0.001268, 0.001936, 0.001926, 0.001460, 
                             0.003943, 0.001160, 0.000781, 0.002430, 0.002673, 0.002618, 0.002097, 0.002021, 0.001903, 0.001649, 0.001727, 0.001524, 0.001512, 0.001051, 0.002029, 0.002398, 0.001853, 0.001803, 0.001494, 0.001659, 0.001948, 0.001916, 0.001754, 0.001882, 0.002098, 0.001373, 0.001383, 0.001657, 0.001907, 0.001344, 0.001598, 0.004632, 0.001527, 0.002316, 0.001827, 0.001624, 0.001717, 0.002351, 0.002092, 0.001208, 0.001586, 0.001223, 0.001830, 0.001354, 0.002223, 0.001942, 0.001952, 0.001281, 0.002301, 0.001074, 0.001052, 0.001964, 0.002100, 0.001201, 0.001652, 0.001497, 0.002498, 0.001310, 0.001779, 0.001708, 0.001757, 0.001364, 0.001557, 0.002037, 0.002051, 0.001336, 0.001271, 0.001779, 0.001872, 0.002041, 0.003700, 0.001763, 0.001639, 0.001742, 0.002310, 0.002192, 0.001690, 0.001939, 0.002099, 0.001911, 0.002090, 0.001681, 0.001624, 0.001647, 0.001414, 0.001946, 0.001436, 0.002011, 0.001734, 0.003441, 0.001157, 0.001144, 0.003896, 0.001646, 0.002338, 0.002016, 0.001626, 0.001656, 0.001073, 0.001236, 0.002105, 0.001630, 0.001665, 0.001299, 0.001428, 0.001387, 0.002303)
  
  PCQDA_Train<-data.frame(Cluster2, Age, MeanDNE.Apex, TotalDNE.TotalPolygonFaces, Proportion.DNEunder0.0001, Proportion.DNEover0.6)
  PCQDA_Train
  }


#' @examples 
#' PCQDA_Train