% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdt_moderated_index.R
\name{add_index.moderated_mediation}
\alias{add_index.moderated_mediation}
\title{add_index method for moderated mediation}
\usage{
\method{add_index}{moderated_mediation}(mediation_model, times = 5000, level = 0.05, stage = NULL, ...)
}
\arguments{
\item{mediation_model}{A mediation model of class
\code{"moderated_mediation"}.}

\item{times}{Number of simulations to use to compute the Monte Carlo indirect
effect confidence interval.}

\item{level}{Alpha threshold to use for the confidence interval.}

\item{stage}{Moderated indirect effect's stage for which to compute the
confidence interval. Can be either \code{1} (or \code{"first"}) or \code{2}
(or \code{"second"}). To compute total indirect effect moderation index,
use \code{"total"}.}

\item{...}{Further arguments passed to or from other methods.}
}
\description{
Adds the confidence interval for the index of moderated
mediation to a model fitted with \code{\link{mdt_moderated}}.
}
\details{
Indirect effect moderation index for moderated mediation uses
\eqn{a}, \eqn{a \times Mod}{a * Mod}, \eqn{b}, and \eqn{b \times Mod}{b *
  Mod} estimates and their standard errors to compute the appropriate index
product distribution using Monte Carlo methods (see Muller, Judd, &
Yzerbyt, 2005).

\pkg{JSmediation} supports different types of mediated indirect effect
index:
\itemize{
\item{Stage 1: }{computes the product between \eqn{a \times Mod}{a
    * Mod} and \eqn{b}.}
\item{Stage 2: }{ computes the product between \eqn{a} and \eqn{b \times
    Mod}{b * Mod}.}
\item{Total: }{ computes the sum of Stage 1 and Stage 2 distribution.}
}
}
\examples{
## getting a stage 1 moderated indirect effect index
ho_et_al$condition_c <- build_contrast(ho_et_al$condition,
                                       "Low discrimination",
                                       "High discrimination")
ho_et_al$linkedfate_c <- scale(ho_et_al$linkedfate, scale = FALSE)
ho_et_al$sdo_c <- scale(ho_et_al$sdo, scale = FALSE)
moderated_model <- mdt_moderated(data = ho_et_al,
                                 IV = condition_c,
                                 DV = hypodescent,
                                 M = linkedfate_c,
                                 Mod = sdo_c)
add_index(moderated_model, stage = 1)

}
\references{
Muller, D., Judd, C. M., & Yzerbyt, V. Y. (2005). When moderation
is mediated and mediation is moderated. \emph{Journal of Personality and
Social Psychology}, 89(6), 852-863. doi: 10.1037/0022-3514.89.6.852
}
