% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{testdistr}
\alias{testdistr}
\title{Graphically compare the distribution of a variable against a specific distribution}
\usage{
testdistr(x, distr = c("normal", "beta", "chisq", "f", "gamma", "nbinom",
  "poisson"), na.rm = TRUE, starts, xlim = NULL, varlab = "X",
  plot = TRUE, ...)
}
\arguments{
\item{x}{The data as a single variable or vector to check the distribution.}

\item{distr}{A character string indicating the distribution to be tested.
Currently one of: \dQuote{normal}, \dQuote{beta}, \dQuote{chisq} (chi-squared),
\dQuote{f}, \dQuote{gamma}, \dQuote{nbinom} (negative binomial), or
\dQuote{poisson}.}

\item{na.rm}{A logical value whether to omit missing values. Defaults to \code{TRUE}.}

\item{starts}{A named list of the starting values. Not required for all distributions.
Passed on to \code{fitdistr} which fits the maximum likelihood estimates of the
distribution parameters.}

\item{xlim}{An optional vector to control the x limits for the theoretical distribution
density line, useful when densities become extreme at boundary values to help keep the
scale of the graph reasonable.  Passed on to \code{stat_function}.}

\item{varlab}{A character vector the label to use for the variable}

\item{plot}{A logical vector whether to plot the graphs. Defaults to \code{TRUE}.}

\item{...}{Additional arguments passed on to \code{geom_density}}
}
\value{
An invisible list with the ggplot2 objects for graphs,
  as well as information about the distribution (parameter estimates,
  name, log likelihood (useful for comparing the fit of different distributions
  to the data), and a dataset with the sorted data and theoretical quantiles.#'
}
\description{
Graphically compare the distribution of a variable against a specific distribution
}
\examples{

## example data
set.seed(1234)
d <- data.frame(
  Ynorm = rnorm(200),
  Ybeta = rbeta(200, 1, 4),
  Ychisq = rchisq(200, 8),
  Yf = rf(200, 5, 10),
  Ygamma = rgamma(200, 2, 2),
  Ynbinom = rnbinom(200, mu = 4, size = 9),
  Ypois = rpois(200, 4))

## testing and graphing
testdistr(d$Ynorm, "normal")
testdistr(d$Ybeta, "beta", starts = list(shape1 = 1, shape2 = 4))
testdistr(d$Ychisq, "chisq", starts = list(df = 8))
testdistr(d$Yf, "f", starts = list(df1 = 5, df2 = 10))
testdistr(d$Ygamma, "gamma")
testdistr(d$Ynbinom, "nbinom")
testdistr(d$Ypois, "poisson")

## compare log likelihood of two different distributions
testdistr(d$Ygamma, "normal")$Distribution$LL
testdistr(d$Ygamma, "gamma")$Distribution$LL

rm(d) ## cleanup
}
\keyword{hplot}

