% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotDiagnosticsLM}
\alias{plotDiagnosticsLM}
\title{Plot Diagnostics for an lm model}
\usage{
plotDiagnosticsLM(object, plot = TRUE, ev.perc = 0.001, ask = TRUE,
  ncol = 1)
}
\arguments{
\item{object}{A fitted model object from lm.}

\item{plot}{A logical value whether or not to plot the results or
simply return the graaphical  objects.}

\item{ev.perc}{A real number between 0 and 1 indicating the
proportion of the theoretical distribution beyond which
values are considered extreme values (possible outliers).
Defaults to .001.}

\item{ask}{A logical whether to ask before changing plots.
Only applies to interactive environments.}

\item{ncol}{The number of columns to use for interactive plots
Must be either 1 or 2.  Defaults to 1.}
}
\value{
a list including plots of the residuals,
  residuals versus fitted values, and one list for
  plots of all random effects and finally a data table with
  any extreme values identified
}
\description{
This function creates a number of diagnostic plots
from lm models. It relies heavily on the \code{testdistr}
function.
}
\examples{
# make me!
}
\keyword{plot}
