% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{.detailedTestsVGLM}
\alias{.detailedTestsVGLM}
\title{Calculates all pairwise contrasts and omnibus tests for multinomial regression}
\usage{
.detailedTestsVGLM(obj, OR = TRUE, digits = 2L, pdigits = 3L)
}
\arguments{
\item{obj}{A \code{vglm} class object, the fitted result of
\code{vglm()}. At the moment only handles the multinomial
family, although this may get expanded in the future.}

\item{OR}{a logical value whether to report odds ratios and
95 percent confidence intervals, if \code{TRUE}, or
regression coefficients on the logit scale with standard
errors, if \code{FALSE}.}

\item{digits}{An integer indicating the number of digits for coefficients,
standard errors, and confidence intervals}

\item{pdigits}{An integer indicating the number of digits for
p-values.}
}
\value{
A list with two elements.
  \code{Results} contains a data table of the actual estimates.
  \code{Table} contains a nicely formatted character matrix.
}
\description{
TODO: make me!
}
\examples{

mtcars$cyl <- factor(mtcars$cyl)
m <- VGAM::vglm(cyl ~ qsec,
  family = VGAM::multinomial(), data = mtcars)
.detailedTestsVGLM(m)

rm(m, mtcars)

\dontrun{
mtcars$cyl <- factor(mtcars$cyl)
mtcars$am <- factor(mtcars$am)
m <- VGAM::vglm(cyl ~ qsec,
  family = VGAM::multinomial(), data = mtcars)
.detailedTestsVGLM(m)

.detailedTestsVGLM(m, digits = 4)$Table
.detailedTestsVGLM(m, OR = FALSE)
.detailedTestsVGLM(m, digits = 4, OR = FALSE)$Table

m <- VGAM::vglm(cyl ~ scale(qsec),
  family = VGAM::multinomial(), data = mtcars)
.detailedTestsVGLM(m)

m2 <- VGAM::vglm(cyl ~ factor(vs) * scale(qsec),
  family = VGAM::multinomial(), data = mtcars)
.detailedTestsVGLM(m2)

m <- VGAM::vglm(Species ~ Sepal.Length,
  family = VGAM::multinomial(), data = iris)
.detailedTestsVGLM(m)
}
}
