% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{modelTest}
\alias{modelTest}
\alias{is.modelTest}
\alias{as.modelTest}
\alias{modelTest.vglm}
\alias{modelTest.lm}
\title{Detailed Tests on Models}
\usage{
modelTest(object, ...)

is.modelTest(x)

as.modelTest(x)

\method{modelTest}{vglm}(object, ...)

\method{modelTest}{lm}(object, ...)
}
\arguments{
\item{object}{A fitted model object.}

\item{...}{Additional arguments passed to specific methods.}

\item{x}{A object (e.g., list or a modelTest object) to
test or attempt coercing to a modelTest object.}
}
\value{
Depends on the method dispatch.

A list with two elements.
  \code{Results} contains a data table of the actual estimates.
  \code{Table} contains a nicely formatted character matrix.

A list with two elements.
  \code{Results} contains a data table of the actual estimates.
  \code{Table} contains a nicely formatted character matrix.
}
\description{
TODO: make me!
}
\examples{
mtcars$cyl <- factor(mtcars$cyl)
m <- VGAM::vglm(cyl ~ qsec,
  family = VGAM::multinomial(), data = mtcars)
modelTest(m)

## clean up
rm(m, mtcars)

\dontrun{
mtcars$cyl <- factor(mtcars$cyl)
mtcars$am <- factor(mtcars$am)
m <- VGAM::vglm(cyl ~ qsec,
  family = VGAM::multinomial(), data = mtcars)
modelTest(m)

m <- VGAM::vglm(cyl ~ scale(qsec),
  family = VGAM::multinomial(), data = mtcars)
modelTest(m)

m2 <- VGAM::vglm(cyl ~ factor(vs) * scale(qsec),
  family = VGAM::multinomial(), data = mtcars)
modelTest(m2)

m <- VGAM::vglm(Species ~ Sepal.Length,
  family = VGAM::multinomial(), data = iris)
modelTest(m)

set.seed(1234)
sampdata <- data.frame(
  Outcome = factor(sample(letters[1:3], 20 * 9, TRUE)),
  C1 = rnorm(20 * 9),
  D3 = sample(paste0("L", 1:3), 20 * 9, TRUE))

m <- VGAM::vglm(Outcome ~ factor(D3),
  family = VGAM::multinomial(), data = sampdata)
modelTest(m)

m <- VGAM::vglm(Outcome ~ factor(D3) + C1,
  family = VGAM::multinomial(), data = sampdata)
modelTest(m)
}
m1 <- lm(mpg ~ qsec * hp, data = mtcars)
modelTest(m1)

mtcars$cyl <- factor(mtcars$cyl)
m2 <- lm(mpg ~ cyl, data = mtcars)
modelTest(m2)

m3 <- lm(mpg ~ hp * cyl, data = mtcars)
modelTest(m3)

m4 <- lm(sqrt(mpg) ~ hp * cyl, data = mtcars)
modelTest(m4)

m5 <- lm(mpg ~ sqrt(hp) * cyl, data = mtcars)
modelTest(m5)

## cleanup
rm(m1, m2, m3, m4, m5, mtcars)
}
