% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JdmbsNewJump.R
\name{jdm_new_bs}
\alias{jdm_new_bs}
\title{A Monte Carlo Option Pricing Algorithm for Jump Diffusion Model with Correlation Companies}
\usage{
jdm_new_bs(companies_data, companies, simulation.length = 180,
  monte_carlo = 1000, start_price, mu, sigma, event_times, jump, K, color)
}
\arguments{
\item{companies_data}{a matrix of a correlation coefficient of companies}

\item{companies}{an integer of company number in order to simulate.}

\item{simulation.length}{an integer of a duration of simulation.}

\item{monte_carlo}{an integer of iterations of monte carlo.}

\item{start_price}{a vector of company's initial stock prices.}

\item{mu}{a vector of parameter of Geometric Brownian motion.}

\item{sigma}{a vector of parameter of Geometric Brownian motion.}

\item{event_times}{an integer of how many times jump in Unit time.}

\item{jump}{a vector of jump parameter.}

\item{K}{a vector of option execution prices.}

\item{color}{a vector of colors in plot.}
}
\value{
premium a list of (call_premium, put_premium)
}
\description{
A Monte Carlo Option Pricing Algorithm for Jump Diffusion Model with Correlation Companies
}
\examples{
jdm_new_bs(matrix(c(1,0.2,0.3,0.4,1,0.6,0.7,0.8,1), nrow=3, ncol=3),
3, simulation.length=60,monte_carlo=60, c(1000,500,500), c(0.005, 0.025, 0.01),
c(0.08,0.04,0.06), 3, c(0.1,0.1,0.1), c(2500,3000,1500), c("red","blue","green"))
}

