% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JointAI.R
\name{sharedParams}
\alias{sharedParams}
\title{Parameters used by several functions in JointAI.}
\arguments{
\item{object}{object inheriting from class 'JointAI'}

\item{no_model}{names of variables for which no model should be specified.
Note that this is only possible for completely observed
variables and implies the assumptions of independence between
the excluded variable and the incomplete variables.}

\item{subset}{subset of parameters/variables/nodes (columns in the MCMC sample).
Uses the same logic as the argument \code{monitor_params} in
\code{\link[JointAI:model_imp]{*_imp}}.}

\item{exclude_chains}{optional vector of the index numbers of chains that should be excluded}

\item{start}{the first iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{end}{the last iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{n.adapt}{the number of iterations for adaptation of the MCMC samplers
(see also \code{\link[rjags]{adapt}})}

\item{n.iter}{the number of iterations of the MCMC chain (after adaptation;
see also \code{\link[rjags]{coda.samples}})}

\item{n.chains}{the number of MCMC chains to be used}

\item{quiet}{if \code{TRUE} then messages generated during compilation
will be suppressed, as well as the progress bar during adaptation
(see \code{\link[rjags]{jags.model}})}

\item{thin}{thinning interval (see \code{\link[coda]{window.mcmc}})}

\item{nrow, ncol}{optional number of rows and columns in the plot layout;
automatically chosen if unspecified}

\item{use_ggplot}{logical; Should ggplot be used instead of the base graphics?}

\item{warn}{logical; should warnings be given? Default is
\code{TRUE}. (Note: this applies only to warnings
given directly by \strong{JointAI}.)}

\item{mess}{logical; should messages be given? Default is
\code{TRUE}. (Note: this applies only to messages
given directly by \strong{JointAI}.)}

\item{xlab, ylab}{labels for the x- and y-axis}

\item{use_level}{logical; should the multi-level structure be taken into account?
This requires specification of the argument \code{idvar}.}

\item{idvar}{name of the column that specifies the multi-level grouping structure}

\item{keep_aux}{logical; Should constant effects of auxiliary variables be kept in the output?}

\item{ridge}{logical; should the parameters of the main model be penalized using ridge regression? Default is \code{FALSE}}

\item{parallel}{logical; should the chains be sampled using parallel computation? Default is \code{FALSE}}

\item{n.cores}{number of cores to use for parallel computation; if left empty all except two cores will be used}

\item{seed}{optional seed value for reproducibility}

\item{ppc}{logical: should monitors for posterior predictive checks be set? (not yet used)}
}
\description{
Parameters used by several functions in JointAI.
}
