% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\name{parameters}
\alias{parameters}
\title{Parameter names of an JointAI object}
\usage{
parameters(object, expand_ranef = FALSE, mess = TRUE, warn = TRUE, ...)
}
\arguments{
\item{object}{object inheriting from class 'JointAI'}

\item{expand_ranef}{logical; should all elements of the random effects
vectors/matrices be shown separately?}

\item{mess}{logical; should messages be given? Default is
\code{TRUE}.}

\item{warn}{logical; should warnings be given? Default is
\code{TRUE}.}

\item{...}{currently not used}
}
\description{
Returns the names of the parameters/nodes of an object of class 'JointAI' for
which a monitor is set.
}
\examples{
# (This function does not need MCMC samples to work, so we will set
# n.adapt = 0 and n.iter = 0 to reduce computational time)
mod1 <- lm_imp(y ~ C1 + C2 + M2 + O2 + B2, data = wideDF, n.adapt = 0,
               n.iter = 0, mess = FALSE)

parameters(mod1)

}
