% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.KFS.R
\name{residuals.KFS}
\alias{residuals.KFS}
\title{Extract Residuals of KFS output}
\usage{
\method{residuals}{KFS}(object, type = c("recursive", "pearson", "response", "state"), ...)
}
\arguments{
\item{object}{KFS object}

\item{type}{Character string defining the type of residuals.}

\item{...}{Ignored.}
}
\description{
Extract Residuals of KFS output
}
\details{
For object of class KFS, several types of residuals can be computed:

  \itemize{ 
  \item  \code{"recursive"}: One-step-ahead prediction residuals
  \eqn{v_{t,i}=y_{t,i}-Z_{t,i}a_{t,i}}{v[t,i]=y[t,i]-Z[t,i]a[t,i]}. For non-Gaussian case recursive
  residuals are computed as \eqn{y_{t}-f(Z_{t}a_{t})}{y[t]-Z[t]a[t]}, i.e.
  non-sequentially. Computing recursive residuals for large non-Gaussian
  models can be time consuming as filtering is needed.

  \item \code{"pearson"}:  \deqn{(y_{t,i}-\theta_{t,i})/\sqrt{V(\mu_{t,i})},
  \quad i=1,\ldots,p,t=1,\ldots,n,}{(y[t,i]-\theta[t,i])V(\mu[t,i])^(-0.5),
  i=1,\ldots,p, t=1,\ldots,n,} where \eqn{V(\mu_{t,i})}{V(\mu[t,i])} is the
  variance function of the series \eqn{i}

  \item \code{"response"}: Data minus fitted values, \eqn{y-E(y)}{y-E(y)}.

  \item \code{"state"}:  Residuals based on the smoothed disturbance terms
  \eqn{\eta} are defined as \deqn{\hat \eta_t, \quad t=1,\ldots,n.}{\hat \eta[t], t=1,\ldots,n.}
  Only defined for fully Gaussian models.
  }
}
