% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LKMO.R
\name{LKMO}
\alias{LKMO}
\title{Optimal KM for Quantitative Traits in Longitudinal GWAS Data (calculate p-value)}
\usage{
LKMO(obj, genotypes, gid, weights = NULL, acc = 1e-04, acc2 = 1e-04,
  r.all = c(0, 0.25, 0.5, 0.75, 1), append.write = NULL)
}
\arguments{
\item{obj}{results saved from LKMO_Null_Model}

\item{genotypes}{1st column: gene name; 2nd column: snp name; 3rd-end columns: A matrix of genotypes for each subject (class: data.frame). The order of 3rd-end columns should match unique(yid). Coded as 0, 1, 2 and no missing. This genotype file can be a big file containing all genes or it can be files containing one single gene.}

\item{gid}{A vector of id mapping to samples in genotype file (class: vector). So the order of samples in gid must be the same as the order in genotypes. Make sure it is not a factor. Although gid doesn't have to be in the same order as yid, it is suggested to make them sorted in the same order in order to make all files easily to be tracked. No missing.}

\item{weights}{1st column: gene name; 2nd column: snp name; 3rd column: A vector with the length equal to the number of variants in the test (class: data.frame). Default is Null indicating equal weight for all markers}

\item{acc}{Accuracy of numerical integration used in Davies' method for individual r.all p-values. Default 1e-4.}

\item{acc2}{Accuracy of numerical integration used in Davies' method for the final p-value. Default 1e-4.}

\item{r.all}{A list of predefined proportion of linear kernel and burden test. When r.all=0, regular kernel machine test (LKM); when r.all=1, burden test.}

\item{append.write}{The name of pvalue output file. Write out p-values in real time. Don't need to wait until all genes are processed to get the final output.}
}
\value{
output: optimal longitudinal KM (L-KMO) p-value
}
\description{
This function (LKMO) is used to perform optimal KM analysis for quantitative traits in GWAS longitudinal data.
}
\examples{
#################################################################################
### Examples for Longitudinal Continuous Traits in GWAS Data using optimal KM ###
#################################################################################
### Subject IDs are numeric ###
data("LKM_numID")
obj1 <- LKMO_Null_Model(phenotype=lkm_n_y$y, time=lkm_n_y$time, yid=lkm_n_y$id,
covariates=NULL)
pvalue1 <- LKMO(obj=obj1, genotypes=lkm_n_gene, gid=lkm_n_gid$gid, weights=NULL,
append.write="./pvalues.out")
# Read in a list of genes files instead of a big file containing all genes
obj <- LKMO_Null_Model(phenotype=lkm_n_y$y, time=lkm_n_y$time, yid=lkm_n_y$id,
covariates=NULL)
gene <- split(lkm_n_gene, lkm_n_gene[,1])
for (k in 1:2) {
  gene[[k]]$gene <- as.character(gene[[k]]$gene)
  pvalue1 <- LKMO(obj=obj, genotypes=gene[[k]], gid=lkm_n_gid$gid, weights=NULL,
  append.write="./pvalues.out")
}
### Subject IDs are character ###
data("LKM_charID")
obj1 <- LKMO_Null_Model(phenotype=lkm_c_y$y, time=lkm_c_y$time,
yid=as.character(lkm_c_y$id), covariates=NULL)
pvalue1 <- LKMO(obj=obj1, genotypes=lkm_c_gene, gid=as.character(lkm_c_gid$gid),
weights=NULL)
}

