% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{hhgsurv_test_stat}
\alias{hhgsurv_test_stat}
\title{A function to return the test statistic of the SG test}
\usage{
hhgsurv_test_stat(s0, s1, time0, time1, time, delta, trt, tau)
}
\arguments{
\item{s0}{A vector of the survival KM estimates in group 0 for all sorted unique times in group 0}

\item{s1}{A vector of the survival KM estimates in group 1 for all sorted unique times in group 1}

\item{time0}{all sorted unique times in group 0}

\item{time1}{all sorted unique times in group 1}

\item{time}{The follow up time for all the data}

\item{delta}{A binary status vector, where 0 stands for censored observations and 1 stands for events (corresponds with time)}

\item{trt}{Group vector, must contain 0 and 1 values only (corresponds with time)}

\item{tau}{The maximum time in which we can estimate the Kaplan Meier in the two groups}
}
\value{
A list with the two test stats and table usage
}
\description{
A function to return the test statistic of the SG test
}
\details{
This is an inner function inside SG package, not for the users.
}
