% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Krig}
\alias{Krig}
\title{Kriging computation.}
\usage{
Krig(Z, K, k, G, g, type = "ordinary", cinv = "syminv")
}
\arguments{
\item{Z}{Observed values of the spatial process.}

\item{K}{Covariance matrix computed for the position \eqn{X} where the spatial process \eqn{Z}
was observed.}

\item{k}{Covariance matrix computed for the position \eqn{X} where the spatial process \eqn{Z}
was observed and the position \eqn{Y} where the spatial process \eqn{Z} will be predicted.}

\item{G}{When universal kriging will be computed, this matrix represents the values of the 
of the functions representing the mean of the process \eqn{Z}, evaluated in the spatial 
points \eqn{X} where the spatial process was first observed.}

\item{g}{When universal kriging will be computed, this matrix represents the evaluation of the
functions representing the mean over the new position points \eqn{Y} where the spatial process
\eqn{Z} will be predicted.}

\item{type}{Type of kriging model, possible values are: simple, ordinary, universal.}

\item{cinv}{Specifies how the inverse of the covariance matrix \eqn{K} will be computed. 
Possible values are: syminv = symmetric matrix inverse computation, inv = usual armadillo
inverse computation, cholinv = Cholesky based inverse computation, ginv = given inverse not
necessary to compute inverse at all.}
}
\value{
Depending of the type of analysis the list of results change.
\item{Z}{New estimated values for Z.}
\item{L}{Linear coefficients determined by kriging.}
\item{J}{Inverse of the covariance matrix.}
\item{tau}{Factor computed in the ordinary and universal kriging.}
\item{alpha}{Factor computed in the ordinary kriging.}
\item{A}{Factor computed in the universal kriging.}
}
\description{
Computes the kriging linear estimator for different types of kriging models.
}
\examples{
library( KRIG )
vignette( topic = 'simple_kriging', package = 'KRIG' )
vignette( topic = 'ordinary_kriging', package = 'KRIG' )
vignette( topic = 'universal_kriging', package = 'KRIG' )
vignette( topic = 'copper_mining_2d', package = 'KRIG' )
}
\author{
Pedro Guarderas \email{pedro.felipe.guarderas@gmail.com}.
}
