% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fittedKspm.R
\name{fitted.kspm}
\alias{fitted.kspm}
\title{Extract Model Fitted values}
\usage{
\method{fitted}{kspm}(object, ...)
}
\arguments{
\item{object}{an object of class "kspm", usually, a result of a call to \code{kspm}.}

\item{...}{additional optional argument (currently unused).}
}
\value{
The vector of fitted values.
}
\description{
Returns fitted values for a model of class "kspm".
}
\examples{
x <- 1:15
z <- runif(15, 1, 6)
y <- 3*x + z^2 + rnorm(15, 0, 2)
fit <- kspm(y, linear = ~ x, kernel = ~ Kernel(z,
kernel.function = "polynomial", d = 2, rho = 1, gamma = 0))
fitted(fit)

}
\references{
Liu, D., Lin, X., and Ghosh, D. (2007). Semiparametric regression of multidimensional genetic pathway data: least squares kernel machines and linear mixed models. Biometrics, 63(4), 1079:1088.
}
\seealso{
\link{kspm} for fitting model, \link{residuals.kspm}, \link{coef.kspm}, \link{nobs.kspm}.
}
\author{
Catherine Schramm, Aurelie Labbe, Celia Greenwood
}
