\name{str_split}
\alias{str_split}
\title{Split a Vector of Strings Following a Regular Structure}
\usage{
  str_split(x, sep, fixed = FALSE, perl = TRUE,
    useBytes = FALSE, names = NULL)
}
\arguments{
  \item{x}{a vector of strings.}

  \item{sep}{the delimiter / \code{\link{regex}} you wish
  to split your strings on.}

  \item{fixed}{logical. If \code{TRUE}, we match \code{sep}
  exactly; otherwise, we use regular expressions. Has
  priority over \code{perl}.}

  \item{perl}{logical. Should perl-compatible regexps be
  used?}

  \item{useBytes}{logical. If \code{TRUE}, matching is done
  byte-by-byte rather than character-by-character.}

  \item{names}{optional: a vector of names to pass to the
  returned \code{data.frame}.}
}
\description{
  This function takes a vector of strings following a
  regular structure, and converts that vector into a
  \code{data.frame}, split on that delimiter. A nice
  wrapper to \code{\link{strsplit}}, essentially - the
  primary bonus is the automatic coersion to a
  \code{data.frame}.
}
\examples{
str_split(
  c("regular_structure", "in_my", "data_here"),
  sep="_",
  names=c("apple", "banana")
)
x <- c("somewhat_different.structure", "in_this.guy")
str_split( x, "[_\\\\.]", names=c("first", "second", "third") )
}
\seealso{
  \code{\link{strsplit}}
}

