/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.kr.morph.AnalysisOutput;
import org.apache.lucene.analysis.kr.morph.MorphException;
import org.apache.lucene.analysis.kr.morph.WordEntry;
import org.apache.lucene.analysis.kr.utils.DictionaryUtil;
import org.apache.lucene.analysis.kr.utils.EomiUtil;
import org.apache.lucene.analysis.kr.utils.IrregularUtil;
import org.apache.lucene.analysis.kr.utils.MorphUtil;
import org.apache.lucene.analysis.kr.utils.SyllableUtil;
import org.apache.lucene.analysis.kr.utils.VerbUtil;

public class NounUtil {
    private static final List DNouns;

    static {
        String[] strs;
        DNouns = new ArrayList();
        String[] stringArray = strs = new String[]{"\ub4f1", "\ub4e4", "\uc0c1", "\uac04", "\ubfd0", "\ubcc4"};
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            DNouns.add(str);
            ++n2;
        }
    }

    public static boolean analysisMJ(AnalysisOutput o, List candidates) throws MorphException {
        block13: {
            block12: {
                int strlen = o.getStem().length();
                if (strlen < 2) {
                    return false;
                }
                char[] chrs = MorphUtil.decompose(o.getStem().charAt(strlen - 1));
                boolean success = false;
                if (o.getStem().charAt(strlen - 1) != '\uae30' && (chrs.length != 3 || chrs[2] != '\u3141')) {
                    return false;
                }
                String start = o.getStem();
                String end = "";
                if (o.getStem().charAt(strlen - 1) == '\uae30') {
                    start = o.getStem().substring(0, strlen - 1);
                    end = "\uae30";
                } else if (o.getStem().charAt(strlen - 1) == '\uc74c') {
                    start = o.getStem().substring(0, strlen - 1);
                    end = "\uc74c";
                }
                String[] eomis = EomiUtil.splitEomi(start, end);
                if (eomis[0] == null) {
                    return false;
                }
                String[] pomis = EomiUtil.splitPomi(eomis[0]);
                o.setStem(pomis[0]);
                o.addElist(eomis[1]);
                o.setPomi(pomis[1]);
                try {
                    if (!NounUtil.analysisVMJ(o.clone(), candidates)) break block12;
                    return true;
                }
                catch (CloneNotSupportedException e) {
                    throw new MorphException(e.getMessage(), e);
                }
            }
            if (!NounUtil.analysisVMXMJ(o.clone(), candidates)) break block13;
            return true;
        }
        if (NounUtil.analysisNSMJ(o.clone(), candidates)) {
            return true;
        }
        if (DictionaryUtil.getVerb(o.getStem()) != null) {
            o.setPos('V');
            o.setPatn(12);
            o.setScore(100);
            candidates.add(o);
            return true;
        }
        return false;
    }

    public static boolean analysisVMJ(AnalysisOutput o, List candidates) throws MorphException {
        String[] irrs = IrregularUtil.restoreIrregularVerb(o.getStem(), o.getElist().get(0));
        if (irrs != null) {
            o.setStem(irrs[0]);
            o.setElist(irrs[1], 0);
        }
        if (DictionaryUtil.getVerb(o.getStem()) != null) {
            o.setPatn(12);
            o.setPos('V');
            o.setScore(100);
            candidates.add(o);
            return true;
        }
        return false;
    }

    public static boolean analysisVMXMJ(AnalysisOutput o, List candidates) throws MorphException {
        int idxXVerb = VerbUtil.endsWithXVerb(o.getStem());
        if (idxXVerb != -1) {
            String eogan = o.getStem().substring(0, idxXVerb);
            o.setXverb(o.getStem().substring(idxXVerb));
            String[] stomis = null;
            stomis = eogan.endsWith("\uc544") || eogan.equals("\uc5b4") ? EomiUtil.splitEomi(eogan.substring(0, eogan.length() - 1), eogan.substring(eogan.length() - 1)) : EomiUtil.splitEomi(eogan, "");
            if (stomis[0] == null) {
                return false;
            }
            String[] irrs = IrregularUtil.restoreIrregularVerb(stomis[0], stomis[1]);
            if (irrs != null) {
                o.setStem(irrs[0]);
                o.addElist(irrs[1]);
            } else {
                o.setStem(stomis[0]);
                o.addElist(stomis[1]);
            }
            if (DictionaryUtil.getVerb(o.getStem()) != null) {
                o.setPatn(15);
                o.setPos('V');
                o.setScore(100);
                candidates.add(o);
                return true;
            }
        }
        return false;
    }

    public static boolean analysisNSMJ(AnalysisOutput o, List candidates) throws MorphException {
        int idxVbSfix = VerbUtil.endsWithVerbSuffix(o.getStem());
        if (idxVbSfix != -1) {
            o.setVsfx(o.getStem().substring(idxVbSfix));
            o.setStem(o.getStem().substring(0, idxVbSfix));
            o.setPatn(4);
            o.setPos('N');
            if (DictionaryUtil.getNoun(o.getStem()) != null) {
                o.setScore(100);
                candidates.add(o);
                return true;
            }
        }
        return false;
    }

    private static List findNouns(String str, int pos, AnalysisOutput o) throws MorphException {
        ArrayList<WordEntry> nList = new ArrayList<WordEntry>();
        if (str.length() == 2 && DictionaryUtil.existSuffix(str.substring(0, 1)) && DNouns.contains(str.substring(1))) {
            o.setStem(o.getStem().substring(0, o.getStem().length() - 1));
            o.setNsfx(str.substring(1));
            nList.add(new WordEntry(str.substring(0, 1)));
            return nList;
        }
        if (str.length() == 2 && DictionaryUtil.existSuffix(str.substring(0, 1)) && DictionaryUtil.existJosa(str.substring(1))) {
            return null;
        }
        if (pos >= 2 && DictionaryUtil.existJosa(str)) {
            return null;
        }
        if (str.length() == 1 && (DictionaryUtil.existSuffix(str) || DNouns.contains(str))) {
            nList.add(new WordEntry(str));
            return nList;
        }
        int i = 1;
        while (i < str.length()) {
            String sub = str.substring(0, i + 1);
            if (!DictionaryUtil.findWithPrefix(sub).hasNext()) break;
            WordEntry entry = DictionaryUtil.getCNoun(sub);
            if (entry != null) {
                nList.add(entry);
            }
            ++i;
        }
        return nList;
    }

    public static boolean confirmDNoun(AnalysisOutput output) throws MorphException {
        int strlen = output.getStem().length();
        String d = output.getStem().substring(strlen - 1);
        if (!DNouns.contains(d)) {
            return false;
        }
        String s = output.getStem().substring(0, strlen - 1);
        output.setNsfx(d);
        output.setStem(s);
        WordEntry cnoun = DictionaryUtil.getCNoun(s);
        if (cnoun != null) {
            if (cnoun.getFeature(0) == '2') {
                output.setCNoun(cnoun.getCompounds());
            } else {
                output.setCNoun(new ArrayList());
            }
            output.setScore(100);
        }
        return true;
    }

    public static boolean endsWith2Josa(String input) throws MorphException {
        boolean josaFlag = true;
        int i = input.length() - 2;
        while (i > 0) {
            String josa = input.substring(i);
            char[] feature = SyllableUtil.getFeature(josa.charAt(0));
            if (josaFlag && DictionaryUtil.existJosa(josa)) {
                return true;
            }
            if (josaFlag && feature[SyllableUtil.IDX_JOSA2] == '0') {
                josaFlag = false;
            }
            if (!josaFlag) break;
            --i;
        }
        return false;
    }

    public static double countFoundNouns(AnalysisOutput o) {
        int count = 0;
        int i = 0;
        while (i < o.getCNounList().size()) {
            if (o.getCNounList().get(i).isExist()) {
                ++count;
            }
            ++i;
        }
        return count * 100 / o.getCNounList().size();
    }
}

