/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.utils;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public final class JarResources {
    public boolean debugOn = false;
    private Hashtable htSizes = new Hashtable();
    private String jarFileName;

    public JarResources(String jarFileName) {
        this.jarFileName = jarFileName;
    }

    public byte[] getResource(String name) {
        return this.read(name);
    }

    private byte[] read(String name) {
        try {
            ZipFile zf = new ZipFile(this.jarFileName);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (this.debugOn) {
                    System.out.println(this.dumpZipEntry(ze));
                }
                this.htSizes.put(ze.getName(), new Integer((int)ze.getSize()));
            }
            zf.close();
            FileInputStream fis = new FileInputStream(this.jarFileName);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ZipInputStream zis = new ZipInputStream(bis);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                int size;
                if (ze.isDirectory()) continue;
                if (this.debugOn) {
                    System.out.println("ze.getName()=" + ze.getName() + "," + "getSize()=" + ze.getSize());
                }
                if ((size = (int)ze.getSize()) == -1) {
                    size = (Integer)this.htSizes.get(ze.getName());
                }
                byte[] b = new byte[size];
                int rb = 0;
                int chunk = 0;
                while (size - rb > 0) {
                    chunk = zis.read(b, rb, size - rb);
                    if (chunk == -1) break;
                    rb += chunk;
                }
                if (this.debugOn) {
                    System.out.println(String.valueOf(ze.getName()) + "  rb=" + rb + ",size=" + size + ",csize=" + ze.getCompressedSize());
                }
                if (!ze.getName().equals(name)) continue;
                return b;
            }
        }
        catch (NullPointerException e) {
            System.out.println("done.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String dumpZipEntry(ZipEntry ze) {
        StringBuffer sb = new StringBuffer();
        if (ze.isDirectory()) {
            sb.append("d ");
        } else {
            sb.append("f ");
        }
        if (ze.getMethod() == 0) {
            sb.append("stored   ");
        } else {
            sb.append("defalted ");
        }
        sb.append(ze.getName());
        sb.append("\t");
        sb.append("" + ze.getSize());
        if (ze.getMethod() == 8) {
            sb.append("/" + ze.getCompressedSize());
        }
        return sb.toString();
    }
}

