/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.lucene.analysis.Token;

class KoreanTokenizerImpl {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0000\u0001\u000f\u0001\u0000\u0001\u0000\u0001\u000e\u0012\u0000\u0001\u0000\u0005\u0000\u0001\u0003\u0001\u0001\u0004\u0000\u0001\u0007\u0001\u0005\u0001\u0002\u0001\u0007\n\t\u0006\u0000\u0001\u0004\u001a\b\u0004\u0000\u0001\u0006\u0001\u0000\u001a\bE\u0000\u0017\b\u0001\u0000\u001f\b\u0001\u0000\u0568\b\n\n\u0086\b\n\n\u026c\b\n\nv\b\n\nv\b\n\nv\b\n\nv\b\n\nw\b\t\nv\b\n\nv\b\n\nv\b\n\n\u00e0\b\n\nv\b\n\n\u0166\b\n\n\u00b6\b\u0100\f\u0e00\b\u1040\u0000\u0150\r`\u0000\u0010\r\u0100\u0000\u0080\r\u0080\u0000\u19c0\r@\u0000\u5200\r\u0c00\u0000\u2bb0\u000b\u2150\u0000\u0200\r\u0465\u0000;\r=\b#\u0000";
    private static final char[] ZZ_CMAP = KoreanTokenizerImpl.zzUnpackCMap("\t\u0000\u0001\u0000\u0001\u000f\u0001\u0000\u0001\u0000\u0001\u000e\u0012\u0000\u0001\u0000\u0005\u0000\u0001\u0003\u0001\u0001\u0004\u0000\u0001\u0007\u0001\u0005\u0001\u0002\u0001\u0007\n\t\u0006\u0000\u0001\u0004\u001a\b\u0004\u0000\u0001\u0006\u0001\u0000\u001a\bE\u0000\u0017\b\u0001\u0000\u001f\b\u0001\u0000\u0568\b\n\n\u0086\b\n\n\u026c\b\n\nv\b\n\nv\b\n\nv\b\n\nv\b\n\nw\b\t\nv\b\n\nv\b\n\nv\b\n\n\u00e0\b\n\nv\b\n\n\u0166\b\n\n\u00b6\b\u0100\f\u0e00\b\u1040\u0000\u0150\r`\u0000\u0010\r\u0100\u0000\u0080\r\u0080\u0000\u19c0\r@\u0000\u5200\r\u0c00\u0000\u2bb0\u000b\u2150\u0000\u0200\r\u0465\u0000;\r=\b#\u0000");
    private static final int[] ZZ_ACTION = KoreanTokenizerImpl.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\u0002\u0001\u0003\u0002\u0002\u0003\u0001\u0004\u0001\u0001\u0001\u0005\u0006\u0000\u0003\u0002\u0001\u0003\u0001\u0005\u0003\u0000\u0001\u0002\u0001\u0003\u0001\u0005\u0001\u0002\u0004\u0003\u0003\u0000\u0001\u0003\u0001\u0006\u0003\u0007\u0002\b\u0002\u0000\u0002\u0005\u0002\u0000\u0002\u0007\u0001\u0003\u0004\u0005\u0001\u0000\u0002\u0007\u0001\u0003\u0004\u0000\u0002\u0003\u0001\t\u0001\u0000\u0001\u0007\u0001\n\u0002\u0000\u0002\u0007\u0001\u0003\u0001\t\u0001\u0000\u0002\u0005\u0001\u0003\u0002\u0005\u0001\u0003\u0002\n\u0001\u0007\u0002\u0003\u0001\u0005\u0002\u0003\u0001\u0005\u0002\u0003\u0002\t\u0001\u0000\u0002\u0007\u0001\u0000\u0001\n\u0001\u0007\u0002\u0005\u0001\n\u0002\u0000\u0001\n\u0001\u0003\u0001\u0007\u0001\u000b\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0001\n\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0007\u0001\u0003\u0001\u0005\u0001\u0003\u0001\u0005\u0001\u0003\u0001\u0007\u0002\u0005\u0001\n\u0002\u0000\u0002\u0003\u0001\u0000\u0002\u0003\u0001\u0000\u0002\u0003\u0001\n\u0001\u0007\u0001\u0003\u0002\u0000\u0002\u0003\u0001\n\u0001\u0000\u0002\u0007\u0002\u0000\u0001\n\u0001\u0000\u0002\u0007\u0001\u0003\u0002\u0000\u0001\u0003\u0001\u0007\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0003\u0001\u0000\u0003\u0003";
    private static final int[] ZZ_ROWMAP = KoreanTokenizerImpl.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u0010\u0000 \u00000\u0000@\u0000P\u0000`\u0000p\u0000\u0080\u0000\u0090\u0000\u00a0\u0000\u00b0\u0000\u00c0\u0000\u00d0\u0000\u00e0\u0000\u00f0\u0000\u0100\u0000\u0110\u0000\u0120\u0000\u0130\u0000\u0140\u0000\u0150\u0000\u0160\u0000\u0170\u0000\u0180\u0000\u0190\u0000\u01a0\u0000\u01b0\u0000\u01c0\u0000\u01d0\u0000\u01e0\u0000\u01f0\u0000\u0200\u0000\u0210\u0000\u0220\u0000\u0230\u0000\u0240\u0000\u0250\u0000\u0260\u0000\u0270\u0000\u0280\u0000\u00d0\u0000\u0290\u0000\u02a0\u0000\u02b0\u0000\u02c0\u0000\u02d0\u0000\u02e0\u0000\u0150\u0000\u02f0\u0000\u0300\u0000\u0310\u0000\u0320\u0000\u0330\u0000\u0340\u0000\u0350\u0000\u0360\u0000\u0370\u0000\u0380\u0000\u0390\u0000\u00a0\u0000\u03a0\u0000\u03b0\u0000\u03c0\u0000\u03d0\u0000\u03e0\u0000\u03f0\u0000\u0400\u0000\u0410\u0000\u0420\u0000\u0430\u0000\u0440\u0000\u0450\u0000\u0460\u0000\u0470\u0000\u0480\u0000\u0490\u0000\u04a0\u0000\u04b0\u0000\u04c0\u0000\u04d0\u0000\u04e0\u0000\u04f0\u0000\u02e0\u0000\u0150\u0000\u0500\u0000\u0510\u0000\u0520\u0000\u0530\u0000\u0540\u0000\u0550\u0000\u0560\u0000\u0570\u0000\u0580\u0000\u00c0\u0000\u01b0\u0000\u0590\u0000\u05a0\u0000\u05b0\u0000\u05c0\u0000\u05d0\u0000\u05e0\u0000\u05f0\u0000\u0600\u0000\u0610\u0000\u0620\u0000\u0630\u0000\u0640\u0000\u0650\u0000\u0660\u0000\u0670\u0000\u0680\u0000\u0690\u0000\u06a0\u0000\u06b0\u0000\u0360\u0000\u06c0\u0000\u06d0\u0000\u06e0\u0000\u06f0\u0000\u0700\u0000\u0710\u0000\u0720\u0000\u0730\u0000\u0740\u0000\u0750\u0000\u0760\u0000\u0770\u0000\u0780\u0000\u0790\u0000\u07a0\u0000\u07b0\u0000\u07c0\u0000\u07d0\u0000\u07e0\u0000\u07f0\u0000\u0800\u0000\u0810\u0000\u0820\u0000\u0830\u0000\u0840\u0000\u0850\u0000\u0860\u0000\u0870\u0000\u0880\u0000\u0890\u0000\u08a0\u0000\u08b0\u0000\u08c0\u0000\u08d0\u0000\u08e0\u0000\u08f0\u0000\u0900\u0000\u0910\u0000\u0920\u0000\u0930\u0000\u0940\u0000\u0950\u0000\u0960\u0000\u0970\u0000\u0980\u0000\u0990\u0000\u09a0\u0000\u09b0\u0000\u09c0\u0000\u09d0\u0000\u09e0\u0000\u09f0\u0000\u0a00\u0000\u0a10\u0000\u0a20\u0000\u0a30";
    private static final int[] ZZ_TRANS = KoreanTokenizerImpl.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0002\u0002\u0001\u0003\u0005\u0002\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u0002\u0019\u0000\u0002\u000b\u0006\u0000\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0002\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0007\u0001\u0015\u0005\u0000\u0001\u0016\u0001\u0000\u0001\u0017\u0002\u0018\u0001\u0019\u0001\u001a\u0002\u0013\u0001\u0007\u0001\u001b\u0004\u0000\u0001\f\u0001\u001c\u0001\u000e\u0001\u000f\u0002\u0018\u0001\u0019\u0001\u001d\u0001\u0013\u0001\u0014\u0001\u0007\u0001\u001e\u000b\u0000\u0003\u001f\u0002\u0007\u0004\u0000\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0002\u0010\u0001\u0011\u0001\u0015\u0001 \u0001!\u0001\u0007\u0001\u0015\u0010\u0000\u0001\t\u0011\u0000\u0001\u0002\u0002\u0000\u0001\"\u0005\u0000\u0001#\u0002$\u0001\u0007\u0001%\u000b\u0000\u0001&\u0001\u0000\u0001&\u0001\u0000\u0001&\u000b\u0000\u0001'\u0001(\u0001)\u0001\u0000\u0001'\u000b\u0000\u0001*\u0001\u0000\u0001*\u0001\u0000\u0001*\u000b\u0000\u0001+\u0001,\u0001+\u0001\u0000\u0001+\u000b\u0000\u0001-\u0002.\u0001\u0000\u0001-\u000b\u0000\u0001\u0011\u0002/\u0001\u0000\u0001\u0011\u0004\u0000\u0001\f\u00010\u0001\u000e\u0001\u000f\u0002\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0007\u0001\u0015\u0005\u0000\u00011\u0001\u0000\u0001\u0017\u0002\u0018\u0001\u0019\u0001\u001a\u0002\u0013\u0001\u0007\u0001\u001b\u0004\u0000\u0001\f\u00011\u0001\u000e\u0001\u000f\u0002\u0018\u0001\u0019\u0001\u001d\u0001\u0013\u0001\u0014\u0001\u0007\u0001\u001e\u0004\u0000\u0001\f\u00010\u0001\u000e\u0001\u000f\u0002\u0010\u0001\u0011\u0001\u0015\u0001 \u0001!\u0001\u0007\u0001\u0015\u0005\u0000\u0001\"\u0005\u0000\u00012\u00023\u0001\u0007\u00014\u000b\u0000\u0003,\u0001\u0000\u0001,\u000b\u0000\u00015\u00026\u0001\u0000\u00015\u000b\u0000\u00017\u00028\u0001\u0000\u00017\u0005\u0000\u00019\u0001\u0000\u0001\u0017\u0002\u0018\u0001\u0019\u0001\u001a\u0002\u0013\u0001\u0007\u0001\u001b\u0005\u0000\u00019\u0001\u0000\u0001\u0017\u0002\u0018\u0001\u0019\u0001\u001b\u0002 \u0001\u0007\u0001\u001b\u0005\u0000\u0001\"\u0005\u0000\u0001:\u00013\u0001;\u0001\u0007\u0001<\u0004\u0000\u0001\f\u00019\u0001\u000e\u0001\u000f\u0002\u0018\u0001\u0019\u0001\u001d\u0001\u0013\u0001\u0014\u0001\u0007\u0001\u001e\u0004\u0000\u0001\f\u00019\u0001\u000e\u0001\u000f\u0002\u0018\u0001\u0019\u0001\u001e\u0001 \u0001!\u0001\u0007\u0001\u001e\u000b\u0000\u0003\u001f\u0001\u0000\u0001\u001f\u0005\u0000\u00011\u0001\u0000\u0001\u0017\u0002\u0018\u0001\u0019\u0001\u001b\u0002 \u0001\u0007\u0001\u001b\u0004\u0000\u0001\f\u00011\u0001\u000e\u0001\u000f\u0002\u0018\u0001\u0019\u0001\u001e\u0001 \u0001!\u0001\u0007\u0001\u001e\f\u0000\u0002=\u0007\u0000\u0001>\u0002\u0000\u0003>\u0001#\u0002$\u0001\u0007\u0001%\u0005\u0000\u0001=\u0002\u0000\u0003?\u0001@\u0002$\u0001\u0007\u0001A\u0005\u0000\u0001>\u0002\u0000\u0003>\u0001%\u0002B\u0001\u0007\u0001%\u0004\u0000\u0001\f\u0006\u0000\u0001&\u0001\u0000\u0001&\u0001\u0000\u0001&\u0005\u0000\u0001C\u0001\u0000\u0001\u0017\u0002D\u0001\u0000\u0001E\u0002(\u0001\u0000\u0001E\u0005\u0000\u0001F\u0001\u0000\u0001\u0017\u0002G\u0001H\u0001I\u0002J\u0001\u0007\u0001K\u0005\u0000\u0001L\u0001\u0000\u0001\u0017\u0002G\u0001H\u0001I\u0002J\u0001\u0007\u0001K\u0005\u0000\u0001M\u0002\u0000\u0001M\u0002\u0000\u0001+\u0001,\u0001+\u0001\u0000\u0001+\u0005\u0000\u0001M\u0002\u0000\u0001M\u0002\u0000\u0003,\u0001\u0000\u0001,\u0005\u0000\u0001D\u0001\u0000\u0001\u0017\u0002D\u0001\u0000\u0001-\u0002.\u0001\u0000\u0001-\u0005\u0000\u0001G\u0001\u0000\u0001\u0017\u0002G\u0001H\u0001N\u0002O\u0001\u0007\u0001P\u0005\u0000\u0001H\u0002\u0000\u0003H\u0001Q\u0002R\u0001\u0007\u0001S\u000b\u0000\u0001E\u0002(\u0001\u0000\u0001E\u0005\u0000\u0001T\u0001\u0000\u0001\u0017\u0002\u0010\u0001\u0011\u00012\u00023\u0001\u0007\u00014\u0005\u0000\u0001U\u0001\u0000\u0001\u0017\u0002\u0018\u0001\u0019\u0001V\u00023\u0001\u0007\u0001W\u0005\u0000\u0001T\u0001\u0000\u0001\u0017\u0002\u0010\u0001\u0011\u00014\u0002X\u0001\u0007\u00014\u0005\u0000\u0001\u0010\u0001\u0000\u0001\u0017\u0002\u0010\u0001\u0011\u00015\u0002Y\u0001\u0007\u0001Z\u0005\u0000\u0001\u0018\u0001\u0000\u0001\u0017\u0002\u0018\u0001\u0019\u00016\u0002Y\u0001\u0007\u0001[\u0005\u0000\u0001\u0011\u0002\u0000\u0003\u0011\u00017\u0002\\\u0001\u0007\u0001]\u0005\u0000\u0001\u0019\u0002\u0000\u0003\u0019\u00018\u0002\\\u0001\u0007\u0001^\u000b\u0000\u00012\u0002V\u0001\u0000\u00012\u0005\u0000\u0001_\u0001\u0000\u0001\u0017\u0002\u0010\u0001\u0011\u00012\u00023\u0001\u0007\u00014\u0005\u0000\u0001`\u0001\u0000\u0001\u0017\u0002\u0018\u0001\u0019\u0001V\u00023\u0001\u0007\u0001W\u0005\u0000\u0001_\u0001\u0000\u0001\u0017\u0002\u0010\u0001\u0011\u00014\u0002X\u0001\u0007\u00014\u000b\u0000\u0001>\u0002a\u0001\u0000\u0001>\u000b\u0000\u0001#\u0002@\u0001\u0000\u0001#\u0005\u0000\u0001?\u0002\u0000\u0003?\u0001@\u0002$\u0001\u0007\u0001A\u0005\u0000\u0001?\u0002\u0000\u0003?\u0001A\u0002B\u0001\u0007\u0001A\u0005\u0000\u0001=\u0002\u0000\u0003?\u0001A\u0002B\u0001\u0007\u0001A\u000b\u0000\u0001b\u0001c\u0001b\u0001\u0000\u0001b\u000b\u0000\u0003d\u0001\u0000\u0001d\u0005\u0000\u0001e\u0001\u0000\u0001\u0017\u0002D\u0001\u0000\u0001E\u0002(\u0001\u0000\u0001E\u000b\u0000\u0003f\u0001\u0000\u0001f\u000b\u0000\u0003g\u0001\u0000\u0001g\u000b\u0000\u0003h\u0001\u0000\u0001h\u0005\u0000\u0001i\u0001\u0000\u0001\u0017\u0002j\u0001k\u0001I\u0002J\u0001\u0007\u0001K\u0005\u0000\u0001l\u0001\u0000\u0001\u0017\u0002j\u0001k\u0001I\u0002J\u0001\u0007\u0001K\u0005\u0000\u0001i\u0001\u0000\u0001\u0017\u0002j\u0001k\u0001K\u0002m\u0001\u0007\u0001K\u000b\u0000\u0001n\u0001f\u0001n\u0001\u0000\u0001n\u000b\u0000\u0003o\u0001\u0000\u0001o\u0005\u0000\u0001j\u0001\u0000\u0001\u0017\u0002j\u0001k\u0001N\u0002O\u0001\u0007\u0001P\u0005\u0000\u0001p\u0001\u0000\u0001\u0017\u0002j\u0001k\u0001N\u0002O\u0001\u0007\u0001P\u0005\u0000\u0001j\u0001\u0000\u0001\u0017\u0002j\u0001k\u0001P\u0002q\u0001\u0007\u0001P\u0005\u0000\u0001k\u0002\u0000\u0003k\u0001Q\u0002R\u0001\u0007\u0001S\u0005\u0000\u0001r\u0002\u0000\u0003k\u0001Q\u0002R\u0001\u0007\u0001S\u0005\u0000\u0001k\u0002\u0000\u0003k\u0001S\u0002s\u0001\u0007\u0001S\u0005\u0000\u0001t\u0001\u0000\u0001\u0017\u0002\u0018\u0001\u0019\u0001V\u00023\u0001\u0007\u0001W\u0005\u0000\u0001t\u0001\u0000\u0001\u0017\u0002\u0018\u0001\u0019\u0001W\u0002X\u0001\u0007\u0001W\u0005\u0000\u0001U\u0001\u0000\u0001\u0017\u0002\u0018\u0001\u0019\u0001W\u0002X\u0001\u0007\u0001W\u0005\u0000\u0001u\u0001\u0000\u0001\u0017\u0002\u0018\u0001\u0019\u00016\u0002Y\u0001\u0007\u0001[\u0005\u0000\u0001\u0010\u0001\u0000\u0001\u0017\u0002\u0010\u0001\u0011\u0001Z\u0002v\u0001\u0007\u0001Z\u0005\u0000\u0001\u0018\u0001\u0000\u0001\u0017\u0002\u0018\u0001\u0019\u0001[\u0002v\u0001\u0007\u0001[\u0005\u0000\u0001w\u0002\u0000\u0003\u0019\u00018\u0002\\\u0001\u0007\u0001^\u0005\u0000\u0001\u0011\u0002\u0000\u0003\u0011\u0001]\u0002x\u0001\u0007\u0001]\u0005\u0000\u0001\u0019\u0002\u0000\u0003\u0019\u0001^\u0002x\u0001\u0007\u0001^\u0005\u0000\u0001y\u0002\u0000\u0003y\u0001@\u0002$\u0001\u0007\u0001A\u0005\u0000\u0001C\u0001\u0000\u0001\u0017\u0002D\u0001\u0000\u0003c\u0001\u0000\u0001c\u0005\u0000\u0001e\u0001\u0000\u0001\u0017\u0002D\u0001\u0000\u0003c\u0001\u0000\u0001c\u0005\u0000\u0001D\u0001\u0000\u0001\u0017\u0002D\u0001\u0000\u0003d\u0001\u0000\u0001d\u000b\u0000\u0003c\u0001\u0000\u0001c\u0005\u0000\u0001T\u0001\u0000\u0001\u0017\u0002\u0010\u0001\u0011\u0001f\u0002z\u0001\u0007\u0001{\u0005\u0000\u0001\u0010\u0001\u0000\u0001\u0017\u0002\u0010\u0001\u0011\u0001g\u0002|\u0001\u0007\u0001}\u0005\u0000\u0001\u0011\u0002\u0000\u0003\u0011\u0001h\u0002~\u0001\u0007\u0001\u007f\u000b\u0000\u0001f\u0002\u0080\u0001\u0000\u0001f\u000b\u0000\u0001g\u0002\u0081\u0001\u0000\u0001g\u000b\u0000\u0001h\u0002\u0082\u0001\u0000\u0001h\u0005\u0000\u0001\"\u0005\u0000\u0001f\u0002z\u0001\u0007\u0001{\u0005\u0000\u0001l\u0001\u0000\u0001\u0017\u0002j\u0001k\u0001K\u0002m\u0001\u0007\u0001K\u0005\u0000\u0001_\u0001\u0000\u0001\u0017\u0002\u0010\u0001\u0011\u0001f\u0002z\u0001\u0007\u0001{\u0005\u0000\u0001M\u0002\u0000\u0001M\u0002\u0000\u0003o\u0001\u0000\u0001o\u0005\u0000\u0001\"\u0005\u0000\u0001g\u0002|\u0001\u0007\u0001}\u0005\u0000\u0001p\u0001\u0000\u0001\u0017\u0002j\u0001k\u0001P\u0002q\u0001\u0007\u0001P\u0005\u0000\u0001\"\u0005\u0000\u0001h\u0002~\u0001\u0007\u0001\u007f\u0005\u0000\u0001r\u0002\u0000\u0003k\u0001S\u0002s\u0001\u0007\u0001S\u0005\u0000\u0001\"\u0005\u0000\u00015\u0002Y\u0001\u0007\u0001Z\u0005\u0000\u0001u\u0001\u0000\u0001\u0017\u0002\u0018\u0001\u0019\u0001[\u0002v\u0001\u0007\u0001[\u0005\u0000\u0001\"\u0005\u0000\u00017\u0002\\\u0001\u0007\u0001]\u0005\u0000\u0001w\u0002\u0000\u0003\u0019\u0001^\u0002x\u0001\u0007\u0001^\u000b\u0000\u0003#\u0001\u0000\u0001#\u0005\u0000\u0001\u0083\u0001\u0000\u0001\u0017\u0002\u0084\u0001\u0085\u0001\u0080\u0002z\u0001\u0007\u0001\u0086\u0005\u0000\u0001T\u0001\u0000\u0001\u0017\u0002\u0010\u0001\u0011\u0001{\u0002\u0087\u0001\u0007\u0001{\u0005\u0000\u0001\u0088\u0001\u0000\u0001\u0017\u0002\u0084\u0001\u0085\u0001\u0081\u0002|\u0001\u0007\u0001\u0089\u0005\u0000\u0001\u0010\u0001\u0000\u0001\u0017\u0002\u0010\u0001\u0011\u0001}\u0002\u008a\u0001\u0007\u0001}\u0005\u0000\u0001\u008b\u0002\u0000\u0003\u0085\u0001\u0082\u0002~\u0001\u0007\u0001\u008c\u0005\u0000\u0001\u0011\u0002\u0000\u0003\u0011\u0001\u007f\u0002\u008d\u0001\u0007\u0001\u007f\u0005\u0000\u0001\u008e\u0001\u0000\u0001\u0017\u0002\u0084\u0001\u0085\u0001\u0080\u0002z\u0001\u0007\u0001\u0086\u0005\u0000\u0001\u0084\u0001\u0000\u0001\u0017\u0002\u0084\u0001\u0085\u0001\u0081\u0002|\u0001\u0007\u0001\u0089\u0005\u0000\u0001\u0085\u0002\u0000\u0003\u0085\u0001\u0082\u0002~\u0001\u0007\u0001\u008c\u0005\u0000\u0001\"\u0005\u0000\u0001\u008f\u0002J\u0001\u0007\u0001\u0090\u000b\u0000\u0001\u0091\u0002N\u0001\u0000\u0001\u0091\u000b\u0000\u0001\u0092\u0002Q\u0001\u0000\u0001\u0092\u0005\u0000\u0001\u008e\u0001\u0000\u0001\u0017\u0002\u0084\u0001\u0085\u0001\u0086\u0002\u0087\u0001\u0007\u0001\u0086\u0005\u0000\u0001\u0083\u0001\u0000\u0001\u0017\u0002\u0084\u0001\u0085\u0001\u0086\u0002\u0087\u0001\u0007\u0001\u0086\u0005\u0000\u0001\"\u0005\u0000\u0001\u0091\u0002O\u0001\u0007\u0001\u0093\u0005\u0000\u0001\u0084\u0001\u0000\u0001\u0017\u0002\u0084\u0001\u0085\u0001\u0089\u0002\u008a\u0001\u0007\u0001\u0089\u0005\u0000\u0001\u0088\u0001\u0000\u0001\u0017\u0002\u0084\u0001\u0085\u0001\u0089\u0002\u008a\u0001\u0007\u0001\u0089\u0005\u0000\u0001\"\u0005\u0000\u0001\u0092\u0002R\u0001\u0007\u0001\u0094\u0005\u0000\u0001\u0085\u0002\u0000\u0003\u0085\u0001\u008c\u0002\u008d\u0001\u0007\u0001\u008c\u0005\u0000\u0001\u008b\u0002\u0000\u0003\u0085\u0001\u008c\u0002\u008d\u0001\u0007\u0001\u008c\u000b\u0000\u0001\u008f\u0002I\u0001\u0000\u0001\u008f\u0005\u0000\u0001\u0095\u0001\u0000\u0001\u0017\u0002\u0096\u0001>\u0001\u008f\u0002J\u0001\u0007\u0001\u0090\u0005\u0000\u0001\u0095\u0001\u0000\u0001\u0017\u0002\u0096\u0001>\u0001\u0090\u0002m\u0001\u0007\u0001\u0090\u0005\u0000\u0001\u0096\u0001\u0000\u0001\u0017\u0002\u0096\u0001>\u0001\u0091\u0002O\u0001\u0007\u0001\u0093\u0005\u0000\u0001>\u0002\u0000\u0003>\u0001\u0092\u0002R\u0001\u0007\u0001\u0094\u0005\u0000\u0001\u0096\u0001\u0000\u0001\u0017\u0002\u0096\u0001>\u0001\u0093\u0002q\u0001\u0007\u0001\u0093\u0005\u0000\u0001>\u0002\u0000\u0003>\u0001\u0094\u0002s\u0001\u0007\u0001\u0094\u000b\u0000\u0001\u0097\u0002\u0098\u0001\u0000\u0001\u0097\u000b\u0000\u0001\u0099\u0002\u009a\u0001\u0000\u0001\u0099\u0005\u0000\u0001e\u0001\u0000\u0001\u0017\u0002D\u0001\u0000\u0001\u0097\u0002\u0098\u0001\u0000\u0001\u0097\u0005\u0000\u0001\u009b\u0001\u0000\u0001\u0017\u0002\u009c\u0001y\u0001\u009d\u0002\u009e\u0001\u0007\u0001\u009f\u0005\u0000\u0001D\u0001\u0000\u0001\u0017\u0002D\u0001\u0000\u0001\u0099\u0002\u009a\u0001\u0000\u0001\u0099\u0005\u0000\u0001\u009c\u0001\u0000\u0001\u0017\u0002\u009c\u0001y\u0001\u00a0\u0002\u00a1\u0001\u0007\u0001\u00a2\u000b\u0000\u0003\u00a3\u0001\u0000\u0001\u00a3\u000b\u0000\u0003\u00a4\u0001\u0000\u0001\u00a4\u0005\u0000\u0001\u00a5\u0001\u0000\u0001\u0017\u0002\u00a6\u0001?\u0001\u009d\u0002\u009e\u0001\u0007\u0001\u009f\u0005\u0000\u0001\u00a7\u0001\u0000\u0001\u0017\u0002\u00a6\u0001?\u0001\u009d\u0002\u009e\u0001\u0007\u0001\u009f\u0005\u0000\u0001\u00a5\u0001\u0000\u0001\u0017\u0002\u00a6\u0001?\u0001\u009f\u0002\u00a8\u0001\u0007\u0001\u009f\u0005\u0000\u0001\u00a6\u0001\u0000\u0001\u0017\u0002\u00a6\u0001?\u0001\u00a0\u0002\u00a1\u0001\u0007\u0001\u00a2\u0005\u0000\u0001\u00a9\u0001\u0000\u0001\u0017\u0002\u00a6\u0001?\u0001\u00a0\u0002\u00a1\u0001\u0007\u0001\u00a2\u0005\u0000\u0001\u00a6\u0001\u0000\u0001\u0017\u0002\u00a6\u0001?\u0001\u00a2\u0002\u00aa\u0001\u0007\u0001\u00a2\u0005\u0000\u0001\u0095\u0001\u0000\u0001\u0017\u0002\u0096\u0001>\u0001\u00a3\u0002\u009e\u0001\u0007\u0001\u00ab\u0005\u0000\u0001\u0096\u0001\u0000\u0001\u0017\u0002\u0096\u0001>\u0001\u00a4\u0002\u00a1\u0001\u0007\u0001\u00ac\u000b\u0000\u0001\u00a3\u0002\u009d\u0001\u0000\u0001\u00a3\u000b\u0000\u0001\u00a4\u0002\u00a0\u0001\u0000\u0001\u00a4\u0005\u0000\u0001\"\u0005\u0000\u0001\u00a3\u0002\u009e\u0001\u0007\u0001\u00ab\u0005\u0000\u0001\u00a7\u0001\u0000\u0001\u0017\u0002\u00a6\u0001?\u0001\u009f\u0002\u00a8\u0001\u0007\u0001\u009f\u0005\u0000\u0001\"\u0005\u0000\u0001\u00a4\u0002\u00a1\u0001\u0007\u0001\u00ac\u0005\u0000\u0001\u00a9\u0001\u0000\u0001\u0017\u0002\u00a6\u0001?\u0001\u00a2\u0002\u00aa\u0001\u0007\u0001\u00a2\u0005\u0000\u0001\u0095\u0001\u0000\u0001\u0017\u0002\u0096\u0001>\u0001\u00ab\u0002\u00a8\u0001\u0007\u0001\u00ab\u0005\u0000\u0001\u0096\u0001\u0000\u0001\u0017\u0002\u0096\u0001>\u0001\u00ac\u0002\u00aa\u0001\u0007\u0001\u00ac\u0003\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = KoreanTokenizerImpl.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\u0000\u0001\t\t\u0001\u0006\u0000\u0005\u0001\u0003\u0000\b\u0001\u0003\u0000\u0007\u0001\u0002\u0000\u0002\u0001\u0002\u0000\u0007\u0001\u0001\u0000\u0003\u0001\u0004\u0000\u0003\u0001\u0001\u0000\u0002\u0001\u0002\u0000\u0004\u0001\u0001\u0000\u0013\u0001\u0001\u0000\u0002\u0001\u0001\u0000\u0005\u0001\u0002\u0000\u0004\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0002\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\n\u0001\u0002\u0000\u0002\u0001\u0001\u0000\u0002\u0001\u0001\u0000\u0005\u0001\u0002\u0000\u0003\u0001\u0001\u0000\u0002\u0001\u0002\u0000\u0001\u0001\u0001\u0000\u0003\u0001\u0002\u0000\u0002\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0002\u0001\u0001\u0000\u0003\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    public static final int ALPHANUM = 0;
    public static final int APOSTROPHE = 1;
    public static final int ACRONYM = 2;
    public static final int COMPANY = 3;
    public static final int EMAIL = 4;
    public static final int HOST = 5;
    public static final int NUM = 6;
    public static final int CJ = 7;
    public static final int ACRONYM_DEP = 8;
    public static final int KOREAN = 9;
    public static final String[] TOKEN_TYPES = new String[]{"<ALPHANUM>", "<APOSTROPHE>", "<ACRONYM>", "<COMPANY>", "<EMAIL>", "<HOST>", "<NUM>", "<CJ>", "<ACRONYM_DEP>", "<KOREAN>"};

    private static int[] zzUnpackAction() {
        int[] result = new int[172];
        int offset = 0;
        offset = KoreanTokenizerImpl.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[172];
        int offset = 0;
        offset = KoreanTokenizerImpl.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[2624];
        int offset = 0;
        offset = KoreanTokenizerImpl.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[172];
        int offset = 0;
        offset = KoreanTokenizerImpl.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public final int yychar() {
        return this.yychar;
    }

    final void getText(Token t) {
        t.setTermBuffer(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    KoreanTokenizerImpl(Reader in) {
        this.zzReader = in;
    }

    KoreanTokenizerImpl(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 156) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzPushbackPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) < 0) {
            return true;
        }
        this.zzEndRead += numRead;
        return false;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzPushbackPos = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public int getNextToken() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block23: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzLexicalState;
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 7: {
                    return 5;
                }
                case 12: {
                    continue block23;
                }
                case 10: {
                    return 8;
                }
                case 13: {
                    continue block23;
                }
                case 9: {
                    return 2;
                }
                case 14: {
                    continue block23;
                }
                case 1: 
                case 15: {
                    continue block23;
                }
                case 5: {
                    return 6;
                }
                case 16: {
                    continue block23;
                }
                case 4: {
                    return 7;
                }
                case 17: {
                    continue block23;
                }
                case 2: {
                    return 0;
                }
                case 18: {
                    continue block23;
                }
                case 8: {
                    return 3;
                }
                case 19: {
                    continue block23;
                }
                case 6: {
                    return 1;
                }
                case 20: {
                    continue block23;
                }
                case 3: {
                    return 9;
                }
                case 21: {
                    continue block23;
                }
                case 11: {
                    return 4;
                }
                case 22: {
                    continue block23;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return -1;
            }
            this.zzScanError(1);
        }
    }
}

