/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.utils;

import org.apache.lucene.analysis.kr.morph.AnalysisOutput;
import org.apache.lucene.analysis.kr.morph.MorphException;
import org.apache.lucene.analysis.kr.utils.MorphUtil;

public class Utilities {
    public static String arrayToString(String[] strs) {
        StringBuffer sb = new StringBuffer();
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            sb.append(str);
            ++n2;
        }
        return sb.toString();
    }

    public static AnalysisOutput cloneOutput(AnalysisOutput o) throws MorphException {
        try {
            return o.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new MorphException(e.getMessage(), e);
        }
    }

    public static String buildOutputString(AnalysisOutput o) {
        StringBuffer buff = new StringBuffer();
        buff.append(MorphUtil.buildTypeString(o.getStem(), o.getPos()));
        if (o.getNsfx() != null) {
            buff.append(",").append(MorphUtil.buildTypeString(o.getNsfx(), 's'));
        }
        if (o.getPatn() == 2 || o.getPatn() == 22) {
            buff.append(",").append(MorphUtil.buildTypeString(o.getJosa(), 'j'));
        } else if (o.getPatn() == 3) {
            buff.append(",").append(MorphUtil.buildTypeString(o.getVsfx(), 't'));
            if (o.getPomi() != null) {
                buff.append(",").append(MorphUtil.buildTypeString(o.getPomi(), 'f'));
            }
            buff.append(",").append(MorphUtil.buildTypeString(o.getEomi(), 'e'));
        } else if (o.getPatn() == 4) {
            buff.append(",").append(MorphUtil.buildTypeString(o.getVsfx(), 't'));
            buff.append(",").append(MorphUtil.buildTypeString(o.getElist().get(0), 'n'));
            buff.append(",").append(MorphUtil.buildTypeString(o.getJosa(), 'j'));
        } else if (o.getPatn() == 5) {
            buff.append(",").append(MorphUtil.buildTypeString(o.getVsfx(), 't'));
            buff.append(",").append(MorphUtil.buildTypeString(o.getElist().get(0), 'c'));
            buff.append(",").append(MorphUtil.buildTypeString(o.getXverb(), 'W'));
            if (o.getPomi() != null) {
                buff.append(",").append(MorphUtil.buildTypeString(o.getPomi(), 'f'));
            }
            buff.append(",").append(MorphUtil.buildTypeString(o.getEomi(), 'e'));
        } else if (o.getPatn() == 6) {
            buff.append(",").append(MorphUtil.buildTypeString(o.getJosa(), 'j'));
            buff.append(",").append(MorphUtil.buildTypeString(o.getElist().get(0), 't'));
            if (o.getPomi() != null) {
                buff.append(",").append(MorphUtil.buildTypeString(o.getPomi(), 'f'));
            }
            buff.append(",").append(MorphUtil.buildTypeString(o.getEomi(), 'e'));
        } else if (o.getPatn() == 7) {
            buff.append(",").append(MorphUtil.buildTypeString(o.getVsfx(), 't'));
            buff.append(",").append(MorphUtil.buildTypeString(o.getElist().get(1), 'c'));
            buff.append(",").append(MorphUtil.buildTypeString(o.getXverb(), 'W'));
            if (o.getPomi() != null) {
                buff.append(",").append(MorphUtil.buildTypeString(o.getPomi(), 'f'));
            }
            buff.append(",").append(MorphUtil.buildTypeString(o.getElist().get(0), 'n'));
            buff.append(",").append(MorphUtil.buildTypeString(o.getJosa(), 'j'));
        } else if (o.getPatn() == 11) {
            if (o.getPomi() != null) {
                buff.append(",").append(MorphUtil.buildTypeString(o.getPomi(), 'f'));
            }
            buff.append(",").append(MorphUtil.buildTypeString(o.getEomi(), 'e'));
        } else if (o.getPatn() == 12) {
            buff.append(",").append(MorphUtil.buildTypeString(o.getElist().get(0), 'n'));
            buff.append(",").append(MorphUtil.buildTypeString(o.getJosa(), 'j'));
        } else if (o.getPatn() == 13) {
            buff.append(",").append(MorphUtil.buildTypeString(o.getElist().get(0), 'n'));
            buff.append(",").append(MorphUtil.buildTypeString(o.getElist().get(1), 's'));
            if (o.getPomi() != null) {
                buff.append(",").append(MorphUtil.buildTypeString(o.getPomi(), 'f'));
            }
            buff.append(",").append(MorphUtil.buildTypeString(o.getEomi(), 'e'));
        } else if (o.getPatn() == 14) {
            buff.append(",").append(MorphUtil.buildTypeString(o.getElist().get(0), 'c'));
            buff.append(",").append(MorphUtil.buildTypeString(o.getXverb(), 'W'));
            if (o.getPomi() != null) {
                buff.append(",").append(MorphUtil.buildTypeString(o.getPomi(), 'f'));
            }
            buff.append(",").append(MorphUtil.buildTypeString(o.getEomi(), 'e'));
        } else if (o.getPatn() == 15) {
            buff.append(",").append(MorphUtil.buildTypeString(o.getElist().get(1), 'c'));
            buff.append(",").append(MorphUtil.buildTypeString(o.getXverb(), 'W'));
            if (o.getPomi() != null) {
                buff.append(",").append(MorphUtil.buildTypeString(o.getPomi(), 'f'));
            }
            buff.append(",").append(MorphUtil.buildTypeString(o.getElist().get(0), 'n'));
            buff.append(",").append(MorphUtil.buildTypeString(o.getJosa(), 'j'));
        }
        return buff.toString();
    }
}

