/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.freesearch.korean;

import java.util.ArrayList;
import kr.pe.freesearch.korean.KoHangul;

public abstract class KoHangulAutomata {
    protected short wordValid = 1;
    protected char choSung = '\u0000';
    protected char jwungSung = '\u0000';
    protected char jongSung = '\u0000';
    protected ArrayList<Character> HangulBuffer = new ArrayList();
    protected ArrayList<Character> Syllables = new ArrayList();
    protected ArrayList<Character> rawChar = new ArrayList();
    protected boolean forceConvert;

    protected void clearComp() {
        this.choSung = '\u0000';
        this.jwungSung = '\u0000';
        this.jongSung = '\u0000';
    }

    protected void pushcomp() {
        if (this.choSung == '\u0000' || this.jwungSung == '\u0000') {
            this.wordValid = 0;
        }
        char[] jamos = new char[]{this.choSung, this.jwungSung, this.jongSung};
        this.Syllables.add(Character.valueOf(KoHangul.convertJamosToHangulSyllable(jamos)));
        this.clearComp();
    }

    protected int finalization() {
        int r = 0;
        ArrayList<Character> rjio = new ArrayList<Character>();
        if (this.choSung != '\u0000' || this.jwungSung != '\u0000' || this.jongSung != '\u0000') {
            this.pushcomp();
        }
        if (this.forceConvert) {
            this.wordValid = (short)2;
        }
        if (!this.rawChar.isEmpty() || !this.Syllables.isEmpty()) {
            if (this.wordValid == 1) {
                rjio.addAll(this.Syllables);
                r = 0;
            } else if (this.wordValid == 2) {
                rjio.addAll(this.Syllables);
                r = 2;
            } else {
                rjio.addAll(this.rawChar);
                r = 1;
            }
            this.wordValid = 1;
            this.rawChar.clear();
            this.Syllables.clear();
            if (!rjio.isEmpty()) {
                this.HangulBuffer.addAll(rjio);
                return r;
            }
        }
        return 0;
    }

    public KoHangulAutomata(boolean force) {
        this.forceConvert = force;
    }

    public void clear() {
        this.HangulBuffer.clear();
        this.rawChar.clear();
        this.Syllables.clear();
        this.wordValid = 1;
        this.clearComp();
    }

    public void setForceConvert(boolean force) {
        this.forceConvert = force;
    }

    public String convert(String strKeyStroke) {
        this.clear();
        int i = 0;
        while (i < strKeyStroke.length()) {
            this.feed(strKeyStroke.charAt(i));
            ++i;
        }
        int isUncompleted = this.finalization();
        if (isUncompleted == 1 && !this.forceConvert) {
            return strKeyStroke;
        }
        Character[] hb = this.HangulBuffer.toArray(new Character[0]);
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < hb.length) {
            sb.append(hb[i2]);
            ++i2;
        }
        return sb.toString();
    }

    protected abstract void feed(char var1);
}

