% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDLErrorPropagation&bootstrapVariance.R
\name{LDL_TGVrnc}
\alias{LDL_TGVrnc}
\title{Calculate LDL variance when triglyceride variance changes}
\usage{
LDL_TGVrnc(dfTG, CHOL, HDL, bootStrpReps = 2000)
}
\arguments{
\item{dfTG}{A data frame where each column contains a different set of
triglyceride values of increasing variance as the column index increases.}

\item{CHOL}{A vector or data frame column containing the cholesterol
values to be used for the calculation of the variance of LDL.}

\item{HDL}{A vector or data frame column containing the HDL
values to be used for the calculation of the variance of LDL.}

\item{bootStrpReps}{(Default=2000) Number of bootstrap iterations
for bootstrap variance calculation.}
}
\value{
The function returns a list with the Error Propagation variance
(ErrPropVrnc) and the bootstrap variance (BootVrnc).
Each list element is a vector of
length equal to the number of columns of the triglyceride data frame supplied as
argument (dfTG) and each vector value corresponds to the respective
variance of the corresponding data frame columns.
}
\description{
This function calculates the variance of LDL using two methods:
Error Propagation and Bootstrap when the triglyceride distribution changes.
It uses a data frame where each column contains a different set of triglyceride values of
increasing variance as the column index increases.
}
\examples{
\dontrun{
dfTG = CV_Range(sampleA$TG, 0, 100, maxRandIter = 3000, plot=FALSE)
LDLTGVar=LDL_TGVrnc( sampleA$CHOL,  sampleA$HDL, dfTG, bootStrpReps=2000)
}
}
