% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIPerrorVariance.R
\name{AIP_TGVrnc}
\alias{AIP_TGVrnc}
\title{Calculate the variance of AIP when TG changes.}
\usage{
AIP_TGVrnc(dfTG, HDL, SI = TRUE, bootStrpReps = 2000)
}
\arguments{
\item{dfTG}{A data frame where each column contains a different set of TG
values of increasing variance as the column index increases.}

\item{HDL}{A vector or data frame column containing the HDL
values to be used for the calculation of the variance of the
Atherogenic Index of Plasma (AIP).}

\item{SI}{Boolean (default=TRUE). AIP is by definition calculated using SI
units for TG and HDL (mmol/L). If mg/dl units are provided instead, SI must
be set to FALSE.}

\item{bootStrpReps}{(Default=2000) Number of bootstrap iterations
for bootstrap variance calculation.}
}
\value{
It returns a list with the first order Error Propagation variance
(ErrPropVrnc), the second order Error Propagation variance (ErrPropVrnc2Ord)
and the bootstrap variance (BootVrnc). Each list element is a vector of
length equal to the number of columns of the TG data frame supplied as
argument (dfTG) and each vector value corresponds to the respective
variance of the corresponding data frame columns.
}
\description{
Calculate the variance of the Atherogenic Index of Plasma (AIP)
using two methods:
Error Propagation (first and second order) and Bootstrap when the
triglyceride distribution changes. It uses a
data frame where each column contains a different set of TG values of
increasing variance as the column index increases.
}
\examples{
\dontrun{
dfTG = CV_Range(sampleA$TG, 0, 100, maxRandIter = 100, plot=FALSE)
AIP_TGVrnc=AIP_TGVrnc(dfTG,sampleA$HDL, bootStrpReps=2000)
}
}
