% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDLErrorPropagation&bootstrapVariance.R
\name{LDL_CHOLVrnc}
\alias{LDL_CHOLVrnc}
\title{Calculate LDL variance when cholesterol variance changes}
\usage{
LDL_CHOLVrnc(dfCHOL, HDL, TG, bootStrpReps = 2000)
}
\arguments{
\item{dfCHOL}{A data frame where each column contains a different set of
cholesterol values of increasing variance as the column index increases.}

\item{HDL}{A vector or data frame column containing the HDL
values to be used for the calculation of the variance of LDL.}

\item{TG}{A vector or data frame column containing the triglyceride
values to be used for the calculation of the variance of LDL.}

\item{bootStrpReps}{(Default=2000) Number of bootstrap iterations
for bootstrap variance calculation.}
}
\value{
The function returns a list with the Error Propagation variance
(ErrPropVrnc) and the bootstrap variance (BootVrnc).
Each list element is a vector of
length equal to the number of columns of the cholesterol data frame supplied as
argument (dfCHOL) and each vector value corresponds to the respective
variance of the corresponding data frame columns.
}
\description{
This function calculates the variance of LDL using two methods:
Error Propagation and Bootstrap when the cholesterol distribution changes. It uses a
data frame where each column contains a different set of cholesterol values of
increasing variance as the column index increases.
}
\examples{
\dontrun{
dfCHOL = CV_Range(sampleA$CHOL, 0, 100, maxRandIter = 3000, plot=FALSE)
LDLCHOLVar = LDL_CHOLVrnc(dfCHOL, sampleA$HDL, sampleA$TG, bootStrpReps=200)
}
}
