% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDproxy_batch.R
\name{LDproxy_batch}
\alias{LDproxy_batch}
\title{Query LDproxy using a list of query variants, one per line.}
\usage{
LDproxy_batch(
  snp,
  pop = "CEU",
  r2d = "r2",
  token = NULL,
  append = FALSE,
  genome_build = "grch37"
)
}
\arguments{
\item{snp}{a character string or data frame listing rsID's or chromosome coordinates (e.g. "chr7:24966446"), one per line}

\item{pop}{a 1000 Genomes Project population, (e.g. YRI or CEU), multiple allowed, default = "CEU"}

\item{r2d}{either "r2" for LD R2 or "d" for LD D', default = "r2"}

\item{token}{LDlink provided user token, default = NULL, register for token at  \url{https://ldlink.nci.nih.gov/?tab=apiaccess}}

\item{append}{A logical. If TRUE, output for each query variant is appended to a text file. If FALSE, output of each query variant is saved in its own text file.
Default is FALSE.}

\item{genome_build}{Choose between one of the three options...`grch37` for genome build GRCh37 (hg19),
`grch38` for GRCh38 (hg38), or `grch38_high_coverage` for GRCh38 High Coverage (hg38) 1000 Genome Project
data sets.  Default is GRCh37 (hg19).}
}
\value{
text file(s) are saved to the current working directory.
}
\description{
Query LDproxy using a list of query variants, one per line.
}
\examples{
\dontrun{snps_to_upload <- c("rs3", "rs4")}
\dontrun{LDproxy_batch(snp = snps_to_upload, token = Sys.getenv("LDLINK_TOKEN"), append = FALSE)}

}
