% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LIC.R
\name{LIC}
\alias{LIC}
\title{The LIC criterion is to determine the most informative subsets so that the subset can retain most of the information contained in the complete data.}
\usage{
LIC(X, Y, alpha, K, nk)
}
\arguments{
\item{X}{is a design matrix}

\item{Y}{is a random response vector of observed values}

\item{alpha}{is the significance level}

\item{K}{is the number of subsets}

\item{nk}{is the sample size of subsets}
}
\value{
MUopt,Bopt,MAEMUopt,MSEMUopt,opt,Yopt
}
\description{
The LIC criterion is to determine the most informative subsets so that the subset can retain most of the information contained in the complete data.
}
\examples{
set.seed(12)
X=matrix(data=sample(1:3,1200*5, replace = TRUE) ,nrow=1200,ncol=5)  
b=sample(1:3,5, replace = TRUE)         
e= rnorm(1200, 0, 1)    
Y=X\%*\%b+e
alpha=0.05	
K=10
nk=1200/K 
LIC(X,Y,alpha,K,nk)
}
