\name{LIMBlending}
\alias{LIMinputBlending}
\alias{LIMBlending}
\docType{data}
\title{
  A blending problem specification
}
\description{
  A manufacturer produces a feeding mix for pet animals.

  The feed mix contains two nutritive ingredients and one ingredient
  (filler) to provide bulk.

  One kg of feed mix must contain a minimum quantity of each of four
  nutrients as below:

       \tabular{rlllll}{
       \tab Nutrient  \tab A  \tab B  \tab C  \tab D \cr
       \tab gram      \tab 80 \tab 50 \tab 25 \tab 5 \cr
       }

  The ingredients have the following nutrient values and cost

       \tabular{rllllll}{
 \tab  (gram/kg)    \tab A   \tab   B \tab C  \tab D    \tab Cost/kg \cr
 \tab Ingredient 1  \tab 100 \tab  50 \tab 40 \tab 10   \tab 40  \cr
 \tab Ingredient 2  \tab 200 \tab 150 \tab 10 \tab  -   \tab 60  \cr
 \tab Filler        \tab -   \tab -   \tab -  \tab  -   \tab 0   \cr
       }
       
  The linear inverse models LIMBlending and LIMinputBlending are generated
  from the file Blending.input
  which can be found in subdirectory \code{/examples/LinearProg} of the
  package directory

  LIMBlending is generated by function \code{Setup}

  LIMinputBlending is generated by function \code{Read}

  The problem is to find the composition of the feeding mix that minimises
  the production costs subject to the constraints above.

  Stated otherwise: what is the optimal amount of ingredients in one kg
  of feeding mix?


  Mathematically this can be estimated by solving a linear programming problem:
  \deqn{\min(\sum {Cost_i*x_i})} subject to
  \deqn{x_i>=0}
  \deqn{Ex=f}
  \deqn{Gx>=h}

  Where the \code{Cost} (to be minimised) is given by:
  \deqn{x_1*40+x_2*60}

  The \code{equality} ensures that the sum of the three fractions equals 1:
  \deqn{1 = x_1+x_2+x_3}

  And the \code{inequalities} enforce the nutritional constraints:
  \deqn{100*x_1+200*x_2>80}
  \deqn{50*x_1+150*x_2>50}
  and so on
 
  The solution is Ingredient1 (x1) = 0.5909, Ingredient2 (x2)=0.1364
  and Filler (x3)=0.2727.
}

\usage{
LIMBlending
LIMinputBlending
}

\format{
  LIMBlending is of type \code{lim}, which is a list of matrices,
  vectors, names and values that specify the linear inverse model problem.

  see the return value of \code{\link{Setup}} for more information about
  this list

  LIMinputBlending is of type \code{liminput}, see the return value of
  \code{\link{Read}} for more information.

  A more complete description of these structures is in vignette("LIM")
}

\author{
  Karline Soetaert <k.soetaert@nioo.knaw.nl>
}

\examples{

# 1. Solve the model with linear programming
res <- Linp(LIMBlending, ispos = TRUE)

# show results
print(c(res$X, Cost = res$solutionNorm))


# 2. Possible ranges of the three ingredients
(xr <- Xranges(LIMBlending, ispos = TRUE))
Nx <- LIMBlending$NUnknowns

# plot
dotchart(x = as.vector(res$X), xlim = range(xr),
         labels = LIMBlending$Unknowns,
         main = "Optimal blending with ranges",
         sub = "using linp and xranges", pch = 16)
segments(xr[ ,1], 1:Nx, xr[ ,2], 1:Nx)
legend  ("topright", pch = c(16, NA), lty = c(NA, 1),
          legend = c("Minimal cost", "range"))

# 3. Random sample of the three ingredients
# The inequality that all x > 0 has to be added!
blend   <- LIMBlending
blend$G <- rbind(blend$G, diag(3))
blend$H <- c(blend$H, rep(0, 3))

xs <- Xsample(blend)

pairs(xs, main = "Blending, 3000 solutions with xsample")
}
\seealso{
  browseURL(paste(system.file(package="LIM"), "/doc/examples/LinearProg/", sep=""))

  contains "blending.input", the input file; read this with \code{Setup}

  \code{\link{LIMTakapoto}}, \code{\link{LIMEcoli}} and many others
}

\keyword{datasets}

