% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Zagent.R
\name{LLMConversation}
\alias{LLMConversation}
\title{LLMConversation Class for Coordinating Agents}
\description{
An R6 class for managing a conversation among multiple \code{Agent} objects.
Holds:
\itemize{
  \item \code{agents}: Named list of Agents, keyed by \code{agent$id}.
  \item \code{conversation_history}: The full log of messages so far.
  \item \code{topic}: A short label or theme for the conversation.
  \item \code{prompts}: Optional named list of prompt templates.
}

Agents do \emph{not} automatically share memory. Whenever you call \code{converse()},
the entire conversation history is \emph{temporarily} loaded into the targeted
agent, which responds, then is pruned again.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{agents}}{A named list of \code{Agent} objects.}

\item{\code{conversation_history}}{A list of speaker/text pairs for the entire conversation.}

\item{\code{topic}}{A short string describing the conversation's theme.}

\item{\code{prompts}}{An optional list of prompt templates (may be ignored).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LLMConversation-new}{\code{LLMConversation$new()}}
\item \href{#method-LLMConversation-add_agent}{\code{LLMConversation$add_agent()}}
\item \href{#method-LLMConversation-add_message}{\code{LLMConversation$add_message()}}
\item \href{#method-LLMConversation-converse}{\code{LLMConversation$converse()}}
\item \href{#method-LLMConversation-run}{\code{LLMConversation$run()}}
\item \href{#method-LLMConversation-print_history}{\code{LLMConversation$print_history()}}
\item \href{#method-LLMConversation-reset_conversation}{\code{LLMConversation$reset_conversation()}}
\item \href{#method-LLMConversation-|>}{\code{LLMConversation$|>()}}
\item \href{#method-LLMConversation-clone}{\code{LLMConversation$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LLMConversation-new"></a>}}
\if{latex}{\out{\hypertarget{method-LLMConversation-new}{}}}
\subsection{Method \code{new()}}{
Create a new conversation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LLMConversation$new(topic, prompts = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{topic}}{Character. The conversation topic.}

\item{\code{prompts}}{Optional named list of prompt templates.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LLMConversation-add_agent"></a>}}
\if{latex}{\out{\hypertarget{method-LLMConversation-add_agent}{}}}
\subsection{Method \code{add_agent()}}{
Add an \code{Agent} to this conversation. The agent is stored by its \code{id}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LLMConversation$add_agent(agent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{agent}}{The \code{Agent} to add.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LLMConversation-add_message"></a>}}
\if{latex}{\out{\hypertarget{method-LLMConversation-add_message}{}}}
\subsection{Method \code{add_message()}}{
Add a message to the global conversation log.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LLMConversation$add_message(speaker, text)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{speaker}}{Character. Who is speaking?}

\item{\code{text}}{Character. What they said.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LLMConversation-converse"></a>}}
\if{latex}{\out{\hypertarget{method-LLMConversation-converse}{}}}
\subsection{Method \code{converse()}}{
Have a specific agent produce a response. The entire global conversation so far
is temporarily loaded into that agent's memory, the agent responds, and then
we store the agent's new message in this conversation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LLMConversation$converse(
  agent_id,
  prompt_template,
  replacements = list(),
  verbose = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{agent_id}}{Character. The ID of the agent to converse.}

\item{\code{prompt_template}}{Character. The prompt template for the agent.}

\item{\code{replacements}}{A named list of placeholders to fill in the prompt.}

\item{\code{verbose}}{Logical. If TRUE, prints extra info.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LLMConversation-run"></a>}}
\if{latex}{\out{\hypertarget{method-LLMConversation-run}{}}}
\subsection{Method \code{run()}}{
Run a multi-step conversation among a sequence of agents.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LLMConversation$run(
  agent_sequence,
  prompt_template,
  replacements = list(),
  verbose = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{agent_sequence}}{Character vector of agent IDs in the order they will speak.}

\item{\code{prompt_template}}{Either a single string or a named list of templates.}

\item{\code{replacements}}{Either a single list or a list-of-lists with per-agent placeholders.}

\item{\code{verbose}}{Logical. If TRUE, prints extra info.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LLMConversation-print_history"></a>}}
\if{latex}{\out{\hypertarget{method-LLMConversation-print_history}{}}}
\subsection{Method \code{print_history()}}{
Print the conversation so far to the console.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LLMConversation$print_history()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LLMConversation-reset_conversation"></a>}}
\if{latex}{\out{\hypertarget{method-LLMConversation-reset_conversation}{}}}
\subsection{Method \code{reset_conversation()}}{
Clear the global conversation and reset all agent memories.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LLMConversation$reset_conversation()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LLMConversation-|>"></a>}}
\if{latex}{\out{\hypertarget{method-LLMConversation-|>}{}}}
\subsection{Method \code{|>()}}{
A pipe-like operator to chain conversation steps. E.g.,
\code{conv |> "Solver"(prompt_template, replacements)}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LLMConversation$|>(agent_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{agent_id}}{Character. The ID of the agent to call next.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LLMConversation-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LLMConversation-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LLMConversation$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
