% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLM_parallel_utils.R
\name{call_llm_par}
\alias{call_llm_par}
\title{Mode 4: Parallel Processing - List of Config-Message Pairs}
\usage{
call_llm_par(
  config_message_pairs,
  tries = 10,
  wait_seconds = 2,
  backoff_factor = 2,
  verbose = FALSE,
  json = FALSE,
  memoize = FALSE,
  max_workers = NULL,
  progress = FALSE
)
}
\arguments{
\item{config_message_pairs}{A list where each element is a list with 'config' and 'messages' elements.}

\item{tries}{Integer. Number of retries for each call. Default is 10.}

\item{wait_seconds}{Numeric. Initial wait time (seconds) before retry. Default is 2.}

\item{backoff_factor}{Numeric. Multiplier for wait time after each failure. Default is 2.}

\item{verbose}{Logical. If TRUE, prints progress and debug information.}

\item{json}{Logical. If TRUE, returns raw JSON responses.}

\item{memoize}{Logical. If TRUE, enables caching for identical requests.}

\item{max_workers}{Integer. Maximum number of parallel workers. If NULL, auto-detects.}

\item{progress}{Logical. If TRUE, shows progress bar.}
}
\value{
A tibble with columns: pair_index, provider, model, response_text, success, error_message, plus all model parameters as additional columns.
}
\description{
Processes a list where each element contains both a config and message pair.
Maximum flexibility for complex workflows with different configs and messages.
This function requires setting up the parallel environment using `setup_llm_parallel`.
}
\examples{
\dontrun{
  # Full flexibility with different configs and messages
  config1 <- llm_config(provider = "openai", model = "gpt-4o-mini",
                        api_key = Sys.getenv("OPENAI_API_KEY"))
  config2 <- llm_config(provider = "openai", model = "gpt-3.5-turbo",
                        api_key = Sys.getenv("OPENAI_API_KEY"))

  pairs <- list(
    list(config = config1, messages = list(list(role = "user", content = "What is AI?"))),
    list(config = config2, messages = list(list(role = "user", content = "Explain ML")))
  )

  # setup paralle Environment
  setup_llm_parallel(workers = 4, verbose = TRUE)

  results <- call_llm_par(pairs)

  # Reset to sequential
  reset_llm_parallel(verbose = TRUE)
}
}
