% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbind.R
\name{rbind.Wald_lmm}
\alias{rbind.Wald_lmm}
\title{Linear Hypothesis Testing Across Linear Mixed Models}
\usage{
\method{rbind}{Wald_lmm}(model, ..., effects = NULL, rhs = NULL, name = NULL, sep = ": ")
}
\arguments{
\item{model}{a \code{Wald_lmm} object (output of \code{anova} applied to a \code{lmm} object)}

\item{...}{possibly other \code{Wald_lmm} objects}

\item{effects}{[character or numeric matrix] how to combine the left-hand side of the hypotheses.
By default identity matrix but can also be \code{"Dunnett"},  \code{"Tukey"}, or  \code{"Sequen"} (see function \code{multcomp::contrMat} from the multcomp package).}

\item{rhs}{[numeric vector] the right hand side of the hypothesis. Should have the same length as the number of row of argument \code{effects}.}

\item{name}{[character vector or NULL] character used to identify each model in the output.
By default, use the name of the outcome of the model.}

\item{sep}{[character] character used to separate the outcome and the covariate when naming the tests.}
}
\description{
Linear hypothesis testing accross linear mixed model.
}
\examples{
## simulate data
set.seed(10)
dL <- sampleRem(1e2, n.times = 3, format = "long")

## estimate mixed models
e.lmm1 <- lmm(Y ~ X1+X2+X3, repetition = ~visit|id, data = dL,
              structure = "CS", df = FALSE)
e.lmm2 <- lmm(Y ~ X1+X8+X9, repetition = ~visit|id, data = dL,
              structure = "CS", df = FALSE)

## select null hypotheses
AAA <- anova(e.lmm1, ci = TRUE, effect = c("X1|X2,X3"="X1=0","X2|X1,X3"="X2=0"))
BBB <- anova(e.lmm2, ci = TRUE, effect = c("X1|X8,X9"="X1=0"))

## combine
ZZZ <- rbind(AAA,BBB)
summary(ZZZ)
}
