% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{weights.Wald_lmm}
\alias{weights.Wald_lmm}
\title{Extract Weights Used to Pool Estimates}
\usage{
\method{weights}{Wald_lmm}(object, method, ...)
}
\arguments{
\item{object}{a \code{Wald_lmm} object, output of \code{anova.lmm}, or \code{rbind.lmm}, or \code{mlmm}.}

\item{method}{[character] method for combining the estimates, one of \code{"average"}, \code{"pool.se"}, \code{"pool.gls"}, \code{"pool.rubin"}.}

\item{...}{Not used. For compatibility with the generic method.}
}
\value{
a numeric vector whose elements sum to 1.
}
\description{
Extract weights used to pool estimates.
}
\examples{
set.seed(10)
dL <- sampleRem(250, n.times = 3, format = "long")

e.mlmm <- mlmm(Y~X1+X2+X6, repetition = ~visit|id, data = dL,
               by = "X4", effects = "X1=0", structure = "CS")
weights(e.mlmm, method = "average")
weights(e.mlmm, method = "pool.fixse")
weights(e.mlmm, method = "pool.se")
weights(e.mlmm, method = "pool.gls")
}
