% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R, R/plot.R
\name{autoplot.profile_lmm}
\alias{autoplot.profile_lmm}
\alias{plot.profile_lmm}
\title{Graphical Display of Profile Likelihood}
\usage{
\method{autoplot}{profile_lmm}(
  object,
  type = "logLik",
  quadratic = TRUE,
  ci = FALSE,
  size = c(3, 2, 1, 1),
  linetype = c("dashed", "dashed", "dashed"),
  shape = 19,
  scales = "free",
  nrow = NULL,
  ncol = NULL,
  ...
)

\method{plot}{profile_lmm}(x, ...)
}
\arguments{
\item{object, x}{an object of class \code{profile_lmm}, output of the \code{profile.lmm} function.}

\item{type}{[character] Should the log-likelihood (\code{"logLik"}) or the ratio to the maximum likelihood (\code{"ratio"}) be displayed?}

\item{quadratic}{[logical] Should a quadratic approximation of the likelihood be displayed?}

\item{ci}{[logical] Should a 95\% confidence intervals obtained from the Wald test (vertical lines) and Likelihood ratio test (horizontal line) be displayed?}

\item{size}{[numeric vector of length 4] Size of the point for the MLE,
width of the line representing the likelihood,
width of the corresponding quadratic approximation,
and width of the line representing the confidence intervals.}

\item{linetype}{[integer vector of length 2] type of line used to represent the quadratic approximation of the likelihood
and the confidence intervals.}

\item{shape}{[integer, >0] type of point used to represent the MLE.}

\item{scales, nrow, ncol}{argument passed to \code{ggplot2::facet_wrap}.}

\item{...}{Not used. For compatibility with the generic method.}
}
\value{
A list with three elements \itemize{
\item \code{data.fit}: data containing the quadratice approximation of the log-likelihood
\item \code{data.ci}: data containing the confidence intervals.
\item \code{plot}: ggplot object.
}
}
\description{
Graphical representation of the profile likelihood from a linear mixed model
}
\section{Functions}{
\itemize{
\item \code{plot(profile_lmm)}: Display Contour of the log-Likelihood

}}
\keyword{hplot}
