% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/HLTest.R
\name{HLTest}
\alias{HLTest}
\title{Display Hosmer-Lemeshow statistic and table of probabilities following logistic
regression using glm with binomial family.}
\format{\describe{
\item{x}{
The function has two arguments: model name, number of groups}
}}
\usage{
HLTest(obj, g)
}
\arguments{
\item{obj}{model name}

\item{g}{number of groups}
}
\value{
list
}
\description{
Provides a Hosmer-Lemeshow statistic and table following logistic regression.
}
\details{
HLTest is a post-estimation function for logistic regression, following the use
of glm(). Usage displays a table of observed vs predicted groups and an overall
H-L goodness-of-fit statistic.
}
\note{
HLTest must be loaded into memory in order to be effectve. As a function in LOGIT,
it is immediately available to a user. My thanks to Bilger and Loughlin for the
use of their function.
}
\examples{
library(MASS)
library(LOGIT)
data(medpar)
mylogit <- glm( died ~  los + white + hmo, family=binomial, data=medpar)
grp10 <- HLTest(obj=mylogit, g=10)
cbind(grp10$observed, round(grp10$expect, digits = 1))
grp10
}
\author{
Adapted from Loughlin, T.M. in Bilder and Loughlin, 2015
}
\references{
Hilbe, J. M. (2015), Practical Guide to Logistic Regression, Chapman & Hall/CRC.

Bilder, C.R. and Loughlin, T.M. (2015), Analysis of Categorical Data with R, Chapman & Hall/CRC.

Hilbe, J. M. (2009), Logistic Regression Models, Chapman & Hall/CRC.

Hosmer, D.W., Lemeshow, S, and Sturdivant, R.X (2013), Applied Logistic Regression, 3rd ed, Wiley.
}
\seealso{
\code{\link{glm}}
}
\keyword{models}

